/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.record;

import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.engine.NullValue;
import cn.devezhao.persist4j.record.FieldValueException;
import cn.devezhao.persist4j.record.RecordVisitor;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface RecordCreator {
    public static final Log LOG = LogFactory.getLog(RecordCreator.class);

    public Record create();

    default public boolean onSetFieldValueWarn(Field field, String value, Record record) {
        return false;
    }

    default public boolean setFieldValue(Field field, String value, Record record) {
        boolean isNew;
        boolean bl = isNew = record.getPrimary() == null;
        if (!(isNew || field.isUpdatable() || this.onSetFieldValueWarn(field, value, record))) {
            LOG.warn((Object)("Could not put value to un-updatable field : " + field));
            return false;
        }
        if (isNew && !field.isCreatable() && !this.onSetFieldValueWarn(field, value, record)) {
            LOG.warn((Object)("Could not put value to un-creatable field : " + field));
            return false;
        }
        boolean noValue = this.isNoValue(value, field);
        if (noValue && isNew && !field.isNullable() && !field.isAutoValue()) {
            throw new FieldValueException("Field [ " + field + " ] must not be null");
        }
        if (noValue) {
            record.setNull(field.getName());
        } else {
            try {
                RecordVisitor.setValueByLiteral(field, value, record);
            }
            catch (Exception ex) {
                LOG.error((Object)("Invalid field value by literal : " + field.getName() + " = " + value));
                throw ex;
            }
        }
        return true;
    }

    default public void verify(Record record) {
        if (record.getPrimary() == null) {
            return;
        }
        ArrayList<String> notNullable = new ArrayList<String>();
        for (Field field : record.getEntity().getFields()) {
            if (FieldType.PRIMARY.equals(field.getType())) continue;
            Object val = record.getObjectValue(field.getName());
            if (field.isNullable() || field.isAutoValue() || val != null && !NullValue.is(val)) continue;
            notNullable.add(field.getName());
        }
        if (!notNullable.isEmpty()) {
            throw new FieldValueException("Must not be null. Entity [ " + record.getEntity().getName() + " ], Fields [ " + StringUtils.join((Object[])notNullable.toArray(new String[0]), (String)", ") + " ]");
        }
    }

    default public boolean isNoValue(String value, Field field) {
        return value == null || StringUtils.isEmpty((String)value);
    }
}

