/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.record;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.engine.StandardRecord;
import cn.devezhao.persist4j.record.FieldValueException;
import cn.devezhao.persist4j.record.RecordCreator;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonRecordCreator
implements RecordCreator {
    private static final Log LOG = LogFactory.getLog(JsonRecordCreator.class);
    public static final String META_FIELD = "metadata";
    protected final Entity entity;
    protected final ID editor;
    protected final JSONObject source;

    public JsonRecordCreator(Entity entity, JSONObject source) {
        this(entity, source, null);
    }

    public JsonRecordCreator(Entity entity, JSONObject source, ID editor) {
        Validate.notNull((Object)entity);
        Validate.notNull((Object)source);
        this.entity = entity;
        this.source = source;
        this.editor = editor;
    }

    @Override
    public Record create() {
        return this.create(true);
    }

    public Record create(boolean ignoreNullValueWhenNew) {
        StandardRecord record = new StandardRecord(this.entity, this.editor);
        JSONObject metadata = this.source.getJSONObject(META_FIELD);
        if (metadata == null) {
            throw new FieldValueException("The `metadata` element must not be null");
        }
        String id = metadata.getString("id");
        if (ID.isId(id)) {
            record.setID(this.entity.getPrimaryField().getName(), ID.valueOf(id));
        }
        for (Map.Entry e : this.source.entrySet()) {
            Field field;
            String fileName = (String)e.getKey();
            if (META_FIELD.equals(fileName)) continue;
            Field field2 = field = this.entity.containsField(fileName) ? this.entity.getField(fileName) : null;
            if (field == null) {
                LOG.warn((Object)("Unable found field [ " + this.entity.getName() + '#' + fileName + " ], will ignore"));
                continue;
            }
            Object fieldValue = e.getValue();
            if (fieldValue != null) {
                fieldValue = fieldValue.toString();
            }
            if (ignoreNullValueWhenNew && record.getPrimary() == null && (fieldValue == null || this.isNoValue((String)fieldValue, field))) continue;
            this.setFieldValue(field, (String)fieldValue, record);
        }
        this.afterCreate(record);
        return record;
    }

    protected void afterCreate(Record record) {
        this.verify(record);
    }
}

