/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Filter;
import cn.devezhao.persist4j.PersistManagerFactory;
import cn.devezhao.persist4j.Query;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.query.AjqlResultImpl;
import cn.devezhao.persist4j.query.BaseQuery;
import cn.devezhao.persist4j.query.Result;
import cn.devezhao.persist4j.query.compiler.QueryCompiler;
import cn.devezhao.persist4j.query.compiler.SelectItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AjqlQuery
extends BaseQuery<Query>
implements Query {
    private static final long serialVersionUID = -2539834203845429816L;
    private final String ajql;
    private transient PersistManagerFactory managerFactory;
    private Filter filter;
    private Map<String, Object> inParameters = new HashMap<String, Object>();
    private QueryCompiler queryCompiler;
    private Result result;

    public AjqlQuery(String ajql, PersistManagerFactory managerFactory) {
        this(ajql, managerFactory, null);
    }

    public AjqlQuery(String ajql, PersistManagerFactory managerFactory, Filter filter) {
        this.ajql = ajql;
        this.managerFactory = managerFactory;
        this.filter = filter;
    }

    @Override
    public Query setParameter(int position, Object value) {
        return this.setParameter(position + "", value);
    }

    @Override
    public Query setParameter(String name, Object value) {
        this.inParameters.put(name, value);
        return this;
    }

    @Override
    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public Result result() {
        if (this.result == null) {
            this.result = new AjqlResultImpl(this);
        }
        return this.result;
    }

    @Override
    public Object[] unique() {
        return this.result().unique();
    }

    @Override
    public Object[][] array() {
        return this.result().array();
    }

    @Override
    public List<Record> list() {
        return this.result().list();
    }

    @Override
    public Record record() {
        return this.result().record();
    }

    @Override
    public Query reset() {
        this.result().reset();
        return this;
    }

    @Override
    public Entity getRootEntity() {
        this.compileQueryIfNeed();
        return this.queryCompiler.getRootEntity();
    }

    @Override
    public SelectItem[] getSelectItems() {
        this.compileQueryIfNeed();
        return this.queryCompiler.getSelectItems();
    }

    private void compileQueryIfNeed() {
        if (this.queryCompiler != null) {
            return;
        }
        this.queryCompiler = new QueryCompiler(this.ajql);
        this.queryCompiler.compile(this.managerFactory.getSQLExecutorContext(), this.filter);
    }

    protected PersistManagerFactory getPersistManagerFactory() {
        return this.managerFactory;
    }

    protected QueryCompiler getQueryCompiler() {
        return this.queryCompiler;
    }

    protected Map<String, Object> getInParameters() {
        return this.inParameters;
    }
}

