/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.metadata.impl;

import cn.devezhao.commons.ByteUtils;
import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.metadata.BaseMetaObject;
import cn.devezhao.persist4j.metadata.MissingMetaExcetion;
import cn.devezhao.persist4j.util.CaseInsensitiveMap;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class EntityImpl
extends BaseMetaObject
implements Entity,
Cloneable {
    private static final long serialVersionUID = 4949038246043880357L;
    private final int typeCode;
    private String nameFieldName;
    private final boolean deletable;
    private String primaryFieldName;
    private Map<String, Field> fieldMap = new CaseInsensitiveMap<Field>();
    private Set<String> fieldSorted = new LinkedHashSet<String>();
    private List<Field> referenceTo = new ArrayList<Field>();
    private Entity mainEntity;
    private List<Entity> detailEntities = new ArrayList<Entity>();

    public EntityImpl(String name, String physicalName, String description, JSONObject extraAttrs, boolean creatable, boolean updatable, boolean queryable, int typeCode, String nameFieldName, boolean deletable) {
        super(name, physicalName, description, extraAttrs, creatable, updatable, queryable);
        this.typeCode = typeCode;
        this.nameFieldName = nameFieldName;
        this.deletable = deletable;
    }

    @Override
    public boolean containsField(String aName) {
        return this.fieldMap.containsKey(aName);
    }

    @Override
    public Field getField(String aName) {
        if (!this.containsField(aName)) {
            throw new MissingMetaExcetion(aName, this.getName());
        }
        return this.fieldMap.get(aName);
    }

    @Override
    public Field[] getFields() {
        return this.fieldMap.values().toArray(new Field[0]);
    }

    @Override
    public Field getNameField() {
        if (StringUtils.isBlank((String)this.nameFieldName)) {
            this.nameFieldName = this.primaryFieldName;
        }
        if (this.containsField(this.nameFieldName)) {
            return this.getField(this.nameFieldName);
        }
        return this.getPrimaryField();
    }

    @Override
    public Field getPrimaryField() {
        return this.getField(this.primaryFieldName);
    }

    @Override
    public Integer getEntityCode() {
        return this.typeCode;
    }

    @Override
    public Field[] getReferenceToFields() {
        return this.getReferenceToFields(Boolean.FALSE, Boolean.FALSE);
    }

    @Override
    public Field[] getReferenceToFields(boolean excludeNReference, boolean excludeAnyReference) {
        ArrayList<Field> refs = new ArrayList<Field>();
        for (Field field : this.referenceTo) {
            if (field.getType() == FieldType.REFERENCE) {
                refs.add(field);
            }
            if (!excludeNReference && field.getType() == FieldType.REFERENCE_LIST) {
                refs.add(field);
            }
            if (excludeAnyReference || field.getType() != FieldType.ANY_REFERENCE) continue;
            refs.add(field);
        }
        return refs.toArray(new Field[0]);
    }

    @Override
    public Entity getMainEntity() {
        return this.mainEntity;
    }

    @Override
    public Entity getDetailEntity() {
        if (this.detailEntities.isEmpty()) {
            return null;
        }
        return this.getDetialEntities()[0];
    }

    @Override
    public Entity[] getDetialEntities() {
        if (this.detailEntities.isEmpty()) {
            return new Entity[0];
        }
        return this.detailEntities.toArray(new Entity[0]);
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    public int hashCode() {
        return ByteUtils.hash((int)this.getEntityCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityImpl)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    @Override
    public String toString() {
        return "<" + this.getEntityCode() + ':' + this.getName() + ">@" + super.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        EntityImpl clone = (EntityImpl)super.clone();
        clone.fieldMap = new CaseInsensitiveMap<Field>(this.fieldMap);
        clone.fieldSorted = new LinkedHashSet<String>(this.fieldSorted);
        clone.referenceTo = new ArrayList<Field>(this.referenceTo);
        clone.mainEntity = null;
        clone.detailEntities = new ArrayList<Entity>();
        return clone;
    }

    public Set<String> getFieldSorted() {
        return new LinkedHashSet<String>(this.fieldSorted);
    }

    protected void addField(Field field) {
        this.fieldMap.put(field.getName(), field);
        this.fieldSorted.add(field.getName());
        if (field.getType() == FieldType.PRIMARY) {
            this.primaryFieldName = field.getName();
            if (this.nameFieldName == null) {
                this.nameFieldName = field.getName();
            }
        }
    }

    protected void addReferenceTo(Field field) {
        this.referenceTo.add(field);
    }

    protected void setMainEntity(Entity mainEntity) {
        Assert.isNull((Object)this.mainEntity, (String)"Cannot reset `mainEntity`");
        this.mainEntity = mainEntity;
        if (!BooleanUtils.toBoolean((String)System.getProperty("persist4j.detailEntities"))) {
            ((EntityImpl)mainEntity).detailEntities.clear();
        }
        ((EntityImpl)mainEntity).detailEntities.add(this);
        ((EntityImpl)mainEntity).detailEntities.sort((o1, o2) -> o2.getEntityCode().compareTo(o1.getEntityCode()));
    }
}

