/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.metadata.impl;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.Type;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.metadata.CascadeModel;
import cn.devezhao.persist4j.metadata.MetadataException;
import cn.devezhao.persist4j.metadata.MetadataFactory;
import cn.devezhao.persist4j.metadata.MissingMetaExcetion;
import cn.devezhao.persist4j.metadata.impl.EntityImpl;
import cn.devezhao.persist4j.metadata.impl.FieldImpl;
import cn.devezhao.persist4j.util.CaseInsensitiveMap;
import cn.devezhao.persist4j.util.StringHelper;
import cn.devezhao.persist4j.util.XmlHelper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ConfigurationMetadataFactory
implements MetadataFactory {
    private static final long serialVersionUID = 496898585196420839L;
    private static final Log LOG = LogFactory.getLog(ConfigurationMetadataFactory.class);
    private final XmlHelper XML_HELPER = new XmlHelper();
    private volatile boolean refreshLocked = false;
    private volatile Map<String, Integer> name2TypeMap = new CaseInsensitiveMap<Integer>();
    private volatile Map<Integer, Entity> entityMap = new HashMap<Integer, Entity>();
    private volatile Document configDocument = null;
    private String configLocation;
    private Dialect dialect;
    private String commonEntityName = null;
    private boolean schemaNameOptimize = false;
    private final Map<Field, String[]> REFFIELD_REFS = new ConcurrentHashMap<Field, String[]>();
    private final Map<String, String> SM_MAPPING = new ConcurrentHashMap<String, String>();

    public ConfigurationMetadataFactory(String configLocation, Dialect dialect) {
        this.configLocation = configLocation;
        this.dialect = dialect;
        this.refresh(true);
    }

    @Override
    public Entity getEntity(String name) {
        this.waitForRefreshLocked();
        return this.getEntityNoLock(name);
    }

    @Override
    public Entity getEntity(int type) {
        this.waitForRefreshLocked();
        Entity e = this.entityMap.get(type);
        if (e == null) {
            throw new MissingMetaExcetion("No such entity [" + type + "]");
        }
        return e;
    }

    protected Entity getEntityNoLock(String name) {
        Integer aType = this.name2TypeMap.get(name);
        if (aType == null) {
            throw new MissingMetaExcetion("No such entity [" + name + "]");
        }
        return this.entityMap.get(aType);
    }

    @Override
    public boolean containsEntity(int aType) {
        this.waitForRefreshLocked();
        return this.name2TypeMap.containsValue(aType);
    }

    @Override
    public Entity[] getEntities() {
        this.waitForRefreshLocked();
        return this.entityMap.values().toArray(new Entity[0]);
    }

    public Document getConfigDocument() {
        this.waitForRefreshLocked();
        return this.configDocument;
    }

    private synchronized void waitForRefreshLocked() {
        if (this.refreshLocked) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MetadataException("Wait for refresh lock fail");
            }
        }
    }

    public synchronized void refresh(boolean initState) {
        Document newlyDocument = this.readConfiguration(initState);
        this.refreshLocked = true;
        this.name2TypeMap.clear();
        this.entityMap.clear();
        this.configDocument = null;
        try {
            this.build(newlyDocument);
            this.configDocument = newlyDocument;
        }
        finally {
            this.refreshLocked = false;
            this.notifyAll();
        }
    }

    protected Document readConfiguration(boolean initState) {
        Document document;
        URL url = this.getClass().getClassLoader().getResource(this.configLocation);
        ArrayList<String> errors = new ArrayList<String>();
        try {
            document = this.XML_HELPER.createSAXReader("", errors, XmlHelper.DEFAULT_DTD_RESOLVER).read(Objects.requireNonNull(url).openStream());
        }
        catch (IOException e) {
            throw new MetadataException("Cannot load metadata config [ " + url + " ]", e);
        }
        catch (DocumentException e) {
            throw new MetadataException("Cannot parse metadata config [ " + url + " ]", e);
        }
        return document;
    }

    private void namingPolicy(String ident, String type) {
        if (!StringHelper.isIdentifier(ident)) {
            throw new MetadataException(type + " name [ " + ident + " ] is wrong! Must starts with ['a-zA-Z'|'_'|'#'] and contains ['a-zA-Z'|'_'|'#'|'0-9'] only");
        }
    }

    protected void build(Document document) {
        Element root = document.getRootElement();
        this.schemaNameOptimize = BooleanUtils.toBoolean((String)root.valueOf("@schema-name-optimize"));
        Entity globalParent = null;
        String allParent = root.valueOf("@default-parent");
        if (!StringUtils.isBlank((String)allParent)) {
            globalParent = this.buildEntity(root.selectSingleNode(String.format("entity[@name='%s']", allParent)), null);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Default entity [ " + globalParent + " ] will merge into all entities"));
            }
            this.commonEntityName = globalParent.getName();
        }
        for (Object o : root.selectNodes("//entity")) {
            Node e = (Node)o;
            if (globalParent != null && globalParent.getName().equals(e.valueOf("@name"))) continue;
            Entity entity = this.buildEntity(e, globalParent);
            this.registerEntity(entity);
        }
        this.buildCompleted();
    }

    private Entity buildEntity(Node entityNode, Entity parent) {
        String typeCode = entityNode.valueOf("@type-code");
        Validate.notEmpty((String)typeCode);
        boolean fieldSchemaNameOptimize = BooleanUtils.toBoolean((String)entityNode.valueOf("@schema-name-optimize"));
        fieldSchemaNameOptimize = fieldSchemaNameOptimize || this.schemaNameOptimize;
        String name = entityNode.valueOf("@name");
        this.namingPolicy(name, "Entity");
        String physicalName = entityNode.valueOf("@physical-name");
        if (StringUtils.isEmpty((String)physicalName)) {
            physicalName = name;
            if (fieldSchemaNameOptimize) {
                physicalName = StringHelper.hyphenate(physicalName);
            }
        }
        this.namingPolicy(physicalName, "Entity physical");
        String nameField = entityNode.valueOf("@name-field");
        String description = entityNode.valueOf("@description");
        String extraAttrs = entityNode.valueOf("@extra-attrs");
        JSONObject extraAttrsJson = JSON.parseObject((String)StringUtils.defaultIfBlank((String)extraAttrs, (String)"{}"));
        String mianEntity = StringUtils.defaultIfBlank((String)entityNode.valueOf("@main"), (String)entityNode.valueOf("@master"));
        if (StringUtils.isNotBlank((String)mianEntity)) {
            this.SM_MAPPING.put(name, mianEntity);
        }
        boolean C = Boolean.parseBoolean(entityNode.valueOf("@creatable"));
        boolean U = Boolean.parseBoolean(entityNode.valueOf("@updatable"));
        boolean Q = Boolean.parseBoolean(entityNode.valueOf("@queryable"));
        boolean D = Boolean.parseBoolean(entityNode.valueOf("@deletable"));
        EntityImpl entity = new EntityImpl(name, physicalName, description, extraAttrsJson, C, U, Q, Integer.parseInt(typeCode), nameField, D);
        CaseInsensitiveMap<FieldImpl> parentFields = new CaseInsensitiveMap<FieldImpl>();
        if (parent != null && !"false".equals(entityNode.valueOf("@parent"))) {
            for (Field field : parent.getFields()) {
                FieldImpl useClone = new FieldImpl(field, entity);
                parentFields.put(field.getName(), useClone);
                if (field.getType() != FieldType.REFERENCE && field.getType() != FieldType.ANY_REFERENCE && field.getType() != FieldType.REFERENCE_LIST) continue;
                this.REFFIELD_REFS.put(useClone, this.REFFIELD_REFS.get(field));
            }
        }
        for (Object e : entityNode.selectNodes("field")) {
            Field field = this.buildField((Node)e, entity, fieldSchemaNameOptimize);
            if (entity.containsField(field.getName())) {
                throw new MetadataException("Field [ " + field + " ] already exists");
            }
            entity.addField(field);
        }
        for (Map.Entry entry : parentFields.entrySet()) {
            if (entity.containsField((String)entry.getKey())) continue;
            entity.addField((Field)entry.getValue());
        }
        return entity;
    }

    private Field buildField(Node fieldNode, Entity ownEntity, boolean fieldSchemaNameOptimize) {
        String name = fieldNode.valueOf("@name");
        this.namingPolicy(name, "field");
        String physicalName = fieldNode.valueOf("@physical-name");
        if (StringUtils.isEmpty((String)physicalName)) {
            physicalName = name;
            if (fieldSchemaNameOptimize) {
                physicalName = StringHelper.hyphenate(physicalName).toUpperCase();
            }
        }
        this.namingPolicy(physicalName, "Field physical");
        Type type = this.dialect.getFieldType(fieldNode.valueOf("@type"));
        Validate.notNull((Object)type);
        boolean C = Boolean.parseBoolean(fieldNode.valueOf("@creatable"));
        boolean U = Boolean.parseBoolean(fieldNode.valueOf("@updatable"));
        boolean Q = Boolean.parseBoolean(fieldNode.valueOf("@queryable"));
        boolean N = Boolean.parseBoolean(fieldNode.valueOf("@nullable"));
        boolean R = Boolean.parseBoolean(fieldNode.valueOf("@repeatable"));
        int maxLength = -1;
        if (StringUtils.isBlank((String)fieldNode.valueOf("@max-length"))) {
            if (type == FieldType.STRING) {
                maxLength = 255;
            } else if (type == FieldType.TEXT) {
                maxLength = 65535;
            }
        } else {
            maxLength = Integer.parseInt(fieldNode.valueOf("@max-length"));
        }
        if (type == FieldType.PRIMARY) {
            R = false;
            N = false;
            U = false;
            C = false;
            maxLength = ID.getIDGenerator().getLength();
        }
        CascadeModel cascade = null;
        if (type == FieldType.REFERENCE || type == FieldType.ANY_REFERENCE) {
            cascade = CascadeModel.parse(fieldNode.valueOf("@cascade"));
            maxLength = ID.getIDGenerator().getLength();
        }
        int decimalScale = type == FieldType.DECIMAL || type == FieldType.DOUBLE ? Integer.parseInt(StringUtils.defaultIfEmpty((String)fieldNode.valueOf("@decimal-scale"), (String)"4")) : 0;
        boolean autoValue = Boolean.parseBoolean(fieldNode.valueOf("@auto-value"));
        if (autoValue) {
            R = false;
            N = false;
            U = false;
            C = false;
            type = FieldType.LONG;
        }
        String desc = fieldNode.valueOf("@description");
        String defaultValue = fieldNode.valueOf("@default-value");
        String extraAttrs = fieldNode.valueOf("@extra-attrs");
        JSONObject extraAttrsJson = JSON.parseObject((String)StringUtils.defaultIfBlank((String)extraAttrs, (String)"{}"));
        FieldImpl field = new FieldImpl(name, physicalName, desc, extraAttrsJson, C, U, Q, ownEntity, type, maxLength, cascade, N, R, autoValue, decimalScale, defaultValue);
        String refs = fieldNode.valueOf("@ref-entity");
        if (type == FieldType.REFERENCE) {
            Validate.notEmpty((String)refs, (String)("Reference field [ " + field + " ] must have attribute ref-entity"));
            this.REFFIELD_REFS.put(field, new String[]{refs});
        } else if (type == FieldType.ANY_REFERENCE || type == FieldType.REFERENCE_LIST) {
            String[] stringArray;
            if (StringUtils.isBlank((String)refs)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = refs.split(",");
            }
            this.REFFIELD_REFS.put(field, stringArray);
        }
        return field;
    }

    private void registerEntity(Entity entity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("register entity " + entity));
        }
        if (this.name2TypeMap.get(entity.getName()) != null || this.entityMap.get(entity.getEntityCode()) != null) {
            throw new MetadataException("Repeated entity : " + entity);
        }
        this.name2TypeMap.put(entity.getName(), entity.getEntityCode());
        this.entityMap.put(entity.getEntityCode(), entity);
    }

    private void buildCompleted() {
        for (Map.Entry<Field, String[]> entry : this.REFFIELD_REFS.entrySet()) {
            FieldImpl field = (FieldImpl)entry.getKey();
            if (field.getOwnEntity().getName().equals(this.commonEntityName)) continue;
            if ("*".equals(entry.getValue()[0])) {
                for (Entity entity : this.entityMap.values()) {
                    field.addReference(entity);
                }
                continue;
            }
            for (String eName : entry.getValue()) {
                field.addReference(this.getEntityNoLock(eName));
            }
        }
        this.REFFIELD_REFS.clear();
        for (Map.Entry<Object, Object> entry : this.SM_MAPPING.entrySet()) {
            Entity detailEntity = this.getEntityNoLock((String)entry.getKey());
            String main = (String)entry.getValue();
            if (this.name2TypeMap.containsKey(main)) {
                ((EntityImpl)detailEntity).setMainEntity(this.getEntityNoLock(main));
                continue;
            }
            throw new MetadataException("No main-entity found : " + main);
        }
        this.SM_MAPPING.clear();
    }
}

