/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.engine;

import cn.devezhao.persist4j.DataAccessException;
import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.PersistException;
import cn.devezhao.persist4j.PersistManager;
import cn.devezhao.persist4j.PersistManagerFactory;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.dialect.Editor;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.DecimalEditor;
import cn.devezhao.persist4j.dialect.editor.DoubleEditor;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.engine.JdbcSupport;
import cn.devezhao.persist4j.engine.NullValue;
import cn.devezhao.persist4j.engine.StatementCallback;
import cn.devezhao.persist4j.exception.SqlExceptionConverter;
import cn.devezhao.persist4j.metadata.CascadeModel;
import cn.devezhao.persist4j.query.QueryedRecord;
import cn.devezhao.persist4j.util.SqlHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class PersistManagerImpl
extends JdbcSupport
implements PersistManager {
    private static final long serialVersionUID = 1204654171280975411L;
    private static final Log LOG = LogFactory.getLog(PersistManagerImpl.class);
    private transient PersistManagerFactory managerFactory;

    public PersistManagerImpl(PersistManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    @Override
    public PersistManagerFactory getPersistManagerFactory() {
        return this.managerFactory;
    }

    @Override
    public Record save(Record record) throws DataAccessException {
        Validate.isTrue((record.getPrimary() == null ? 1 : 0) != 0);
        if (record instanceof QueryedRecord) {
            LOG.warn((Object)"QueryedRecord do not use for save");
        }
        Entity e = record.getEntity();
        return this.saveInternal(record, ID.newId(e.getEntityCode()));
    }

    public Record saveInternal(final Record record, final ID recordeId) throws DataAccessException {
        int affected;
        Validate.isTrue((recordeId != null ? 1 : 0) != 0);
        Entity e = record.getEntity();
        StringBuilder insert = new StringBuilder("insert into ");
        insert.append(this.quote(e.getPhysicalName())).append(" ( ").append(this.quote(e.getPrimaryField().getPhysicalName()));
        StringBuilder valuesclause = new StringBuilder("values ( ?");
        final LinkedList<Field> fieldList = new LinkedList<Field>();
        fieldList.add(e.getPrimaryField());
        Iterator<String> iter = record.getAvailableFieldIterator();
        while (iter.hasNext()) {
            Field field = e.getField(iter.next());
            fieldList.add(field);
            insert.append(", ").append(this.quote(field.getPhysicalName()));
            valuesclause.append(", ?");
        }
        insert.append(" ) ").append((CharSequence)valuesclause.append(" )"));
        final String sql = insert.toString();
        try {
            affected = this.execute(new StatementCallback(){

                @Override
                public String getSql() {
                    return sql;
                }

                @Override
                public Object doInParameters(PreparedStatement pstmt) {
                    int index = 1;
                    for (Field field : fieldList) {
                        Editor editor = field.getType().getFieldEditor();
                        try {
                            Object value = field.getType() == FieldType.PRIMARY ? recordeId : record.getObjectValue(field.getName());
                            if (NullValue.is(value)) {
                                pstmt.setNull(index, PersistManagerImpl.this.managerFactory.getDialect().getSqlType(editor.getType()));
                            } else if (field.getType() == FieldType.DOUBLE && field.getDecimalScale() != 4) {
                                ((DoubleEditor)editor).set(pstmt, index, value, field.getDecimalScale());
                            } else if (field.getType() == FieldType.DECIMAL && field.getDecimalScale() != 4) {
                                ((DecimalEditor)editor).set(pstmt, index, value, field.getDecimalScale());
                            } else {
                                editor.set(pstmt, index, value);
                            }
                            ++index;
                        }
                        catch (Exception ex) {
                            throw new PersistException(field.getOwnEntity().getName() + "#" + field.getName(), ex);
                        }
                    }
                    return null;
                }
            });
        }
        catch (SQLException sqlex) {
            throw SqlExceptionConverter.convert(sqlex, "#INSERT", sql);
        }
        LOG.debug((Object)("total affected " + affected + " rows"));
        record.setID(e.getPrimaryField().getName(), recordeId);
        return record;
    }

    @Override
    public Record update(final Record record) throws DataAccessException {
        Validate.notNull((Object)record.getPrimary());
        if (record instanceof QueryedRecord) {
            LOG.warn((Object)"QueryedRecord do not use for update");
        }
        Entity e = record.getEntity();
        StringBuilder update = new StringBuilder("update ");
        update.append(this.quote(e.getPhysicalName())).append(" set ");
        final LinkedList<Field> fieldList = new LinkedList<Field>();
        Iterator<String> iter = record.getAvailableFieldIterator();
        boolean first = true;
        while (iter.hasNext()) {
            Field field = e.getField(iter.next());
            if (field.getType() == FieldType.PRIMARY) continue;
            fieldList.add(field);
            if (first) {
                first = false;
            } else {
                update.append(", ");
            }
            update.append(this.quote(field.getPhysicalName())).append(" = ?");
        }
        update.append(" where ").append(this.quote(e.getPrimaryField().getPhysicalName())).append(" = ?");
        fieldList.add(e.getPrimaryField());
        final String sql = update.toString();
        int affected = 0;
        try {
            if (!first) {
                affected = this.execute(new StatementCallback(){

                    @Override
                    public String getSql() {
                        return sql;
                    }

                    @Override
                    public Object doInParameters(PreparedStatement pstmt) throws SQLException {
                        int index = 1;
                        for (Field field : fieldList) {
                            Editor editor = field.getType().getFieldEditor();
                            Object value = record.getObjectValue(field.getName());
                            if (NullValue.is(value)) {
                                pstmt.setNull(index++, PersistManagerImpl.this.managerFactory.getDialect().getSqlType(editor.getType()));
                                continue;
                            }
                            if (field.getType() == FieldType.DOUBLE && field.getDecimalScale() != 4) {
                                ((DoubleEditor)editor).set(pstmt, index++, value, field.getDecimalScale());
                                continue;
                            }
                            if (field.getType() == FieldType.DECIMAL && field.getDecimalScale() != 4) {
                                ((DecimalEditor)editor).set(pstmt, index++, value, field.getDecimalScale());
                                continue;
                            }
                            editor.set(pstmt, index++, value);
                        }
                        return null;
                    }
                });
            }
        }
        catch (SQLException sqlex) {
            throw SqlExceptionConverter.convert(sqlex, "#UPDATE", sql);
        }
        LOG.debug((Object)("total affected " + affected + " rows"));
        return record;
    }

    @Override
    public Record saveOrUpdate(Record record) throws DataAccessException {
        return record.getPrimary() == null ? this.save(record) : this.update(record);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int delete(ID id) throws DataAccessException {
        void var8_12;
        int[] batchAffected;
        Validate.notNull((Object)id);
        Entity entity = this.managerFactory.getMetadataFactory().getEntity(id.getEntityCode());
        Field[] referenceTos = entity.getReferenceToFields();
        String delete = MessageFormat.format("delete from {0} where {1} = ''{2}''", this.quote(entity.getPhysicalName()), this.quote(entity.getPrimaryField().getPhysicalName()), id.toLiteral());
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(delete);
        if (referenceTos.length > 0) {
            HashMap<Field, ID[]> refToIdMap = new HashMap<Field, ID[]>();
            for (Field rto : referenceTos) {
                ID[] referenceToIds;
                if (rto.getCascadeModel() == CascadeModel.Ignore || (referenceToIds = this.getReferenceToIds(rto, id)).length <= 0) continue;
                refToIdMap.put(rto, referenceToIds);
            }
            for (Map.Entry entry : refToIdMap.entrySet()) {
                Field cField = (Field)entry.getKey();
                if (cField.getType() != FieldType.REFERENCE && cField.getType() != FieldType.ANY_REFERENCE) continue;
                String formatted = null;
                if (cField.getCascadeModel() == CascadeModel.Delete) {
                    formatted = "delete from {0} where {1} = ''{2}''";
                } else if (cField.getCascadeModel() == CascadeModel.RemoveLinks) {
                    formatted = cField.isNullable() ? "update {0} set {1} = NULL where {1} = ''{2}''" : "update {0} set {1} = '''' where {1} = ''{2}''";
                } else {
                    LOG.warn((Object)("Unknow CascadeModel: " + (Object)((Object)cField.getCascadeModel())));
                }
                if (formatted == null) continue;
                String cql = MessageFormat.format(formatted, this.quote(cField.getOwnEntity().getPhysicalName()), this.quote(cField.getPhysicalName()), id.toLiteral());
                sqlList.add(cql);
            }
        }
        try {
            batchAffected = this.executeBatch(sqlList.toArray(new String[0]));
        }
        catch (SQLException sQLException) {
            throw SqlExceptionConverter.convert(sQLException, "#DELETE", null);
        }
        boolean bl = false;
        for (int ba : batchAffected) {
            var8_12 += ba;
        }
        LOG.debug((Object)("total affected " + (int)var8_12 + " rows"));
        return (int)var8_12;
    }

    @Override
    public int[] delete(ID[] ids) throws DataAccessException {
        int[] rowsAffected = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            rowsAffected[i] = this.delete(ids[i]);
        }
        return rowsAffected;
    }

    @Override
    protected Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.managerFactory.getDataSource());
    }

    @Override
    protected void releaseConnection(Connection connect) {
        SqlHelper.close(connect, this.managerFactory.getDataSource());
    }

    private String quote(String ident) {
        return this.managerFactory.getDialect().quote(ident);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ID[] getReferenceToIds(Field referenceToField, ID masterId) {
        ArrayList<ID> ids;
        block14: {
            Entity own = referenceToField.getOwnEntity();
            if (referenceToField.getType() != FieldType.REFERENCE && referenceToField.getType() != FieldType.ANY_REFERENCE) {
                return ID.EMPTY_ID_ARRAY;
            }
            String sql = MessageFormat.format("select {0} from {1} where {2} = ''{3}'' and {2} is not null", this.quote(own.getPrimaryField().getPhysicalName()), this.quote(own.getPhysicalName()), this.quote(referenceToField.getPhysicalName()), masterId.toLiteral());
            ids = new ArrayList<ID>();
            ResultSet rs = null;
            try {
                rs = this.nativeQuery(sql);
                while (rs.next()) {
                    String val = rs.getString(1);
                    ids.add(ID.valueOf(val));
                }
                if (rs == null) break block14;
            }
            catch (SQLException sqlex) {
                try {
                    throw SqlExceptionConverter.convert(sqlex, "#GET_REFERENCE_TO_IDS", sql);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SqlHelper.close(rs);
                        Connection conn2 = null;
                        try {
                            Statement stmt = rs.getStatement();
                            conn2 = stmt == null ? null : stmt.getConnection();
                            SqlHelper.close(stmt);
                        }
                        catch (SQLException e) {
                            LOG.debug(null, (Throwable)e);
                        }
                        if (conn2 != null) {
                            this.releaseConnection(conn2);
                        }
                    }
                    throw throwable;
                }
            }
            SqlHelper.close(rs);
            Connection conn = null;
            try {
                Statement stmt = rs.getStatement();
                conn = stmt == null ? null : stmt.getConnection();
                SqlHelper.close(stmt);
            }
            catch (SQLException e) {
                LOG.debug(null, (Throwable)e);
            }
            if (conn != null) {
                this.releaseConnection(conn);
            }
        }
        if (ids.isEmpty()) {
            return ID.EMPTY_ID_ARRAY;
        }
        return ids.toArray(new ID[0]);
    }
}

