/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.engine;

import cn.devezhao.persist4j.Filter;
import cn.devezhao.persist4j.PersistManager;
import cn.devezhao.persist4j.PersistManagerFactory;
import cn.devezhao.persist4j.Query;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.engine.PersistManagerImpl;
import cn.devezhao.persist4j.engine.SqlExecutorContext;
import cn.devezhao.persist4j.metadata.MetadataFactory;
import cn.devezhao.persist4j.query.AjqlQuery;
import cn.devezhao.persist4j.query.NativeQuery;
import cn.devezhao.persist4j.query.NativeQueryImpl;
import javax.sql.DataSource;

public class PersistManagerFactoryImpl
implements PersistManagerFactory {
    private static final long serialVersionUID = -3863550450762257322L;
    private final DataSource dataSource;
    private final Dialect dialect;
    private final MetadataFactory metadataFactory;
    private final SqlExecutorContext executorContext;

    public PersistManagerFactoryImpl(DataSource dataSource, Dialect dialect, MetadataFactory metadataFactory) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.metadataFactory = metadataFactory;
        this.executorContext = new SqlExecutorContext(metadataFactory, dialect, dataSource);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public MetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    @Override
    public SqlExecutorContext getSQLExecutorContext() {
        return this.executorContext;
    }

    @Override
    public PersistManager createPersistManager() {
        return new PersistManagerImpl(this);
    }

    @Override
    public Query createQuery(String ajql) {
        return this.createQuery(ajql, null);
    }

    @Override
    public Query createQuery(String ajql, Filter filter) {
        return new AjqlQuery(ajql, this, filter);
    }

    @Override
    public NativeQuery createNativeQuery(String sql) {
        return new NativeQueryImpl(sql, this);
    }
}

