/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.engine;

import cn.devezhao.persist4j.DataAccessException;
import cn.devezhao.persist4j.engine.StatementCallback;
import cn.devezhao.persist4j.util.SqlHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JdbcSupport {
    private static final Log LOG = LogFactory.getLog(JdbcSupport.class);
    private static final int TIMEOUT_DEFAULT = 300;
    private int timeout;

    protected JdbcSupport() {
        this(300);
    }

    protected JdbcSupport(int timeout) {
        this.timeout = timeout;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(StatementCallback callback) throws SQLException, DataAccessException {
        int n;
        Connection connect = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exec sql: " + callback.getSql()));
            }
            pstmt = connect.prepareStatement(callback.getSql());
            pstmt.setQueryTimeout(this.getTimeout());
            callback.doInParameters(pstmt);
            n = pstmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            try {
                throw sqlex;
                catch (Throwable unex) {
                    throw new DataAccessException("Unexception on execute", unex);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.close(pstmt);
                this.releaseConnection(connect);
                throw throwable;
            }
        }
        SqlHelper.close(pstmt);
        this.releaseConnection(connect);
        return n;
    }

    public int[] executeBatch(final String[] sqls) throws SQLException, DataAccessException {
        int[] rowsAffected;
        if (sqls.length == 1) {
            int exec = this.execute(new StatementCallback(){

                @Override
                public String getSql() {
                    return sqls[0];
                }

                @Override
                public Object doInParameters(PreparedStatement pstmt) {
                    return null;
                }
            });
            return new int[]{exec};
        }
        Connection connect = this.getConnection();
        Statement stmt = null;
        try {
            stmt = connect.createStatement();
            stmt.setQueryTimeout(this.getTimeout());
            if (SqlHelper.supportsBatchUpdates(connect)) {
                for (String sql : sqls) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("add sql to batch: " + sql));
                    }
                    stmt.addBatch(sql);
                }
                rowsAffected = stmt.executeBatch();
            } else {
                rowsAffected = new int[sqls.length];
                for (int i = 0; i < sqls.length; ++i) {
                    String crtSql = sqls[i];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("exec sql(batch): " + crtSql));
                    }
                    if (stmt.execute(crtSql)) {
                        SqlHelper.close(stmt);
                        throw new DataAccessException("Invalid batch SQL statement: " + crtSql);
                    }
                    rowsAffected[i] = stmt.getUpdateCount();
                }
            }
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        catch (Throwable unex) {
            if (unex instanceof DataAccessException) {
                throw (DataAccessException)((Object)unex);
            }
            throw new DataAccessException("Unexception on executeBatch", unex);
        }
        finally {
            SqlHelper.close(stmt);
            this.releaseConnection(connect);
        }
        return rowsAffected;
    }

    protected ResultSet nativeQuery(String sql) throws SQLException, DataAccessException {
        ResultSet rs;
        Connection connect = this.getConnection();
        try {
            Statement stmt = connect.createStatement();
            stmt.setQueryTimeout(this.getTimeout());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exec query: " + sql));
            }
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        catch (Throwable unex) {
            throw new DataAccessException("Unexception on nativeQuery", unex);
        }
        return rs;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected abstract Connection getConnection();

    protected abstract void releaseConnection(Connection var1);
}

