/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect.editor;

import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.StringEditor;
import cn.devezhao.persist4j.engine.ID;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class ReferenceListEditor
extends StringEditor {
    private static final long serialVersionUID = -7654860974427302836L;
    public static final String VALUE_SEP = ",";

    @Override
    public int getType() {
        return FieldType.REFERENCE_LIST.getMask();
    }

    @Override
    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        String text = this.toLiteral(value);
        super.set(pstmt, index, text);
    }

    @Override
    public Object get(ResultSet rs, int index) throws SQLException {
        String v = rs.getString(index);
        if (StringUtils.isBlank((String)v)) {
            return null;
        }
        ArrayList<ID> ids = new ArrayList<ID>();
        for (String id : v.split(VALUE_SEP)) {
            ids.add(ID.valueOf(id));
        }
        return ids.isEmpty() ? null : ids.toArray(new ID[0]);
    }

    @Override
    public String toLiteral(Object value) {
        if (value == null) {
            return null;
        }
        Object[] ids = (ID[])value;
        return ids.length == 0 ? null : StringUtils.join((Object[])ids, (String)VALUE_SEP);
    }
}

