/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.momentjava.util;

import cn.devezhao.momentjava.util.DateFormatException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Date parse(String source) {
        return DateUtils.parse(source, null);
    }

    public static Date parse(String source, String pattern) {
        try {
            if (pattern != null) {
                return new SimpleDateFormat(pattern).parse(source);
            }
            if (source.length() == 6) {
                return new SimpleDateFormat("yyMMdd").parse(source);
            }
            if (source.length() == 8) {
                return new SimpleDateFormat("yyyyMMdd").parse(source);
            }
            if (source.length() == 10) {
                return new SimpleDateFormat("yyyy-MM-dd").parse(source);
            }
            if (source.length() == 19) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(source);
            }
            throw new DateFormatException("source = " + source);
        }
        catch (DateFormatException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DateFormatException("source = " + source, ex);
        }
    }

    public static int getDayLeft(Date end) {
        return DateUtils.getDayLeft(DateUtils.now(), end);
    }

    public static int getDayLeft(Date begin, Date end) {
        return (int)DateUtils.subtract(end, begin, 6);
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        Calendar cal = DateUtils.calendar();
        cal.setTime(date);
        return cal;
    }

    public static Date startTime(Date date) {
        Calendar cal = DateUtils.calendar(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date endTime(Date date) {
        Calendar cal = DateUtils.calendar(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static long subtract(Date subtrahend, Date minuend, int field) {
        BigDecimal smLeft = BigDecimal.valueOf(subtrahend.getTime()).subtract(BigDecimal.valueOf(minuend.getTime()));
        if (field == 14) {
            return smLeft.longValue();
        }
        if (field == 13) {
            return DateUtils.subtractFormat(smLeft, 1000L);
        }
        if (field == 12) {
            return DateUtils.subtractFormat(smLeft, 60000L);
        }
        if (field == 10 || field == 11) {
            return DateUtils.subtractFormat(smLeft, 3600000L);
        }
        if (field == 6 || field == 5) {
            return DateUtils.subtractFormat(smLeft, 86400000L);
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(subtrahend);
        c2.setTime(minuend);
        long yearLeft = c1.get(1) - c2.get(1);
        if (field == 2) {
            long monthLeft = c1.get(2) - c2.get(2);
            return monthLeft += yearLeft * 12L;
        }
        if (field == 1) {
            return yearLeft;
        }
        throw new UnsupportedOperationException("field: " + field);
    }

    private static long subtractFormat(BigDecimal x, long divisor) {
        x = x.divide(BigDecimal.valueOf(divisor), 2, RoundingMode.HALF_UP);
        return x.setScale(0, RoundingMode.UP).longValue();
    }
}

