/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.xml;

import cn.devezhao.commons.xml.XSLTParser;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class XSLTParserFactory {
    private static TransformerFactory transformerFactory;

    private XSLTParserFactory() {
        transformerFactory = TransformerFactory.newInstance();
    }

    public static XSLTParser newParser(InputStream stream) {
        StreamSource source = new StreamSource(stream);
        Transformer t = XSLTParserFactory.newTransformer(source);
        return new XSLTParser(t);
    }

    public static Transformer newTransformer(StreamSource source) {
        try {
            return transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Could't create xslt transformer!", e);
        }
    }

    static {
        new XSLTParserFactory();
    }
}

