/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.xml;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FastSAXReader {
    private static final Log LOG = LogFactory.getLog(FastSAXReader.class);
    private final int initial;
    private final Queue<XMLReader> xmlReadres = new ConcurrentLinkedQueue<XMLReader>();

    public FastSAXReader(int initial) {
        this.initial = initial;
        this.doInitAllCache();
    }

    public SAXReader getSAXParser(boolean xxe) {
        XMLReader xmlReader = this.xmlReadres.poll();
        if (xmlReader == null) {
            LOG.warn((Object)"No more cache, create new XMLReader ....");
            xmlReader = this.doCachingOneReader(null);
        }
        SAXReader saxReader = new SAXReader(xmlReader);
        saxReader.setMergeAdjacentText(true);
        if (xxe) {
            try {
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return saxReader;
    }

    public void release(SAXReader reader) {
        try {
            this.xmlReadres.add(reader.getXMLReader());
        }
        catch (SAXException e) {
            LOG.warn((Object)"Release SAXReader to cache fail!", (Throwable)e);
        }
    }

    private void doInitAllCache() {
        LOG.debug((Object)("Initializing " + this.initial + " SAXReader in cache"));
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            for (int i = 0; i < this.initial; ++i) {
                this.doCachingOneReader(factory);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private XMLReader doCachingOneReader(SAXParserFactory factory) {
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/validation", false);
            this.xmlReadres.add(reader);
            return reader;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

