/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.sql.builder;

import cn.devezhao.commons.sql.SqlHelper;
import cn.devezhao.commons.sql.builder.BaseBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class InsertBuilder
extends BaseBuilder {
    private final Map<String, Object> columns = new LinkedHashMap<String, Object>();

    public InsertBuilder(String table) {
        super(table);
    }

    public InsertBuilder addColumn(String column) {
        return this.addColumn(column, ObjectUtils.NULL);
    }

    public InsertBuilder addColumn(String column, Object value) {
        if (value == null) {
            return this;
        }
        this.columns.put(column, value);
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(SqlHelper.wrapIdent(this.getTable().toLowerCase())).append(" (");
        StringBuilder values = new StringBuilder(") values (");
        for (Map.Entry<String, Object> e : this.columns.entrySet()) {
            sql.append(SqlHelper.wrapIdent(e.getKey())).append(", ");
            Object v = e.getValue();
            if (ObjectUtils.NULL == v) {
                values.append("null");
            } else if (Number.class.isAssignableFrom(v.getClass())) {
                values.append(v);
            } else {
                values.append('\'').append(this.escapeSql(v)).append('\'');
            }
            values.append(", ");
        }
        int len = sql.length();
        sql.delete(len - 2, len);
        len = values.length();
        values.delete(len - 2, len);
        sql.append((CharSequence)values).append(")");
        return sql.toString();
    }

    public boolean hasColumn() {
        return !this.columns.isEmpty();
    }
}

