/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.identifier;

import cn.devezhao.commons.ByteUtils;
import cn.devezhao.commons.identifier.IdentifierGenerator;
import java.io.Serializable;
import java.net.InetAddress;

public class UUIDHexGenerator
implements IdentifierGenerator {
    private static final int IP;
    private static short counter;
    private static final int JVM;
    protected final char sep;

    public UUIDHexGenerator() {
        this('-');
    }

    public UUIDHexGenerator(char sep) {
        this.sep = sep;
    }

    @Override
    public Serializable generate() {
        return this.format(this.getIP()) + this.sep + this.format(this.getJVM()) + this.sep + this.format(this.getMoTime()) + this.sep + this.format(this.getLoTime()) + this.sep + this.format(this.getCount());
    }

    @Override
    public int getLength() {
        return 36;
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuilder buf = new StringBuilder("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuilder buf = new StringBuilder("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    protected int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCount() {
        Class<UUIDHexGenerator> clazz = UUIDHexGenerator.class;
        synchronized (UUIDHexGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    protected int getIP() {
        return IP;
    }

    protected short getMoTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    static {
        int ipadd;
        try {
            ipadd = ByteUtils.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception ex) {
            ipadd = 0;
        }
        IP = ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
    }
}

