/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.excel;

import cn.devezhao.commons.excel.CSVReader;
import cn.devezhao.commons.excel.ExcelReader;
import cn.devezhao.commons.excel.ExcelReaderException;
import cn.devezhao.commons.excel.XExcelReader;
import java.io.Closeable;
import java.io.File;
import javax.xml.stream.XMLStreamReader;

public class ExcelReaderFactory {
    public static ExcelReader create(File excel) throws ExcelReaderException {
        return ExcelReaderFactory.create(excel, "UTF-8");
    }

    public static ExcelReader create(File excel, String encoding) throws ExcelReaderException {
        if (excel != null && excel.getName().endsWith(".xlsx")) {
            return new XExcelReader(excel);
        }
        if (excel != null && excel.getName().endsWith(".xls")) {
            return new ExcelReader(excel);
        }
        if (excel != null && excel.getName().endsWith(".csv")) {
            return new CSVReader(excel, encoding);
        }
        throw new ExcelReaderException("Invalid Excel/CSV file: " + excel);
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void close(XMLStreamReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

