/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.excel;

import cn.devezhao.commons.excel.Cell;
import cn.devezhao.commons.excel.ExcelReaderException;
import cn.devezhao.commons.excel.ExcelReaderFactory;
import cn.devezhao.commons.excel.IRow;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
implements Iterator<Cell[]>,
Closeable {
    private Workbook workbook;
    private Sheet sheet;
    protected int rowCount = 0;
    protected int rowIndex = 0;

    protected ExcelReader() {
    }

    public ExcelReader(File excel) {
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(excel);
            this.workbook = new HSSFWorkbook(fs);
        }
        catch (IOException e) {
            this.close();
            throw new ExcelReaderException(e);
        }
        this.sheetAt(0);
    }

    public String[] getSheetNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            names.add(this.workbook.getSheetName(i));
        }
        return names.toArray(new String[0]);
    }

    public void sheetAt(int index) {
        if (index > this.workbook.getNumberOfSheets()) {
            throw new ExcelReaderException("\u65e0\u6548 SHEET \u4f4d\u7f6e: " + index);
        }
        this.sheet = this.workbook.getSheetAt(index);
        this.rowCount = this.sheet.getPhysicalNumberOfRows();
        this.rowIndex = 0;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public boolean hasNext() {
        return this.getRowIndex() < this.getRowCount();
    }

    @Override
    public Cell[] next() {
        ArrayList<Cell> rowValues = new ArrayList<Cell>();
        Row row = this.sheet.getRow(this.rowIndex++);
        for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
            org.apache.poi.ss.usermodel.Cell cell = row.getCell(i);
            rowValues.add(this.readCell(cell));
        }
        return rowValues.toArray(new Cell[0]);
    }

    public IRow nextRow() {
        Cell[] cells = this.next();
        if (cells == null) {
            return null;
        }
        return new IRow(cells, this.rowIndex);
    }

    private Cell readCell(org.apache.poi.ss.usermodel.Cell cell) {
        if (cell == null) {
            return Cell.NULL;
        }
        int rowNo = cell.getAddress().getRow();
        int columnNo = cell.getAddress().getColumn();
        CellType type = cell.getCellTypeEnum();
        if (type == CellType.BOOLEAN) {
            return Cell.valueOf(cell.getBooleanCellValue(), rowNo, columnNo);
        }
        if (type == CellType.NUMERIC || type == CellType.FORMULA) {
            if (DateUtil.isCellDateFormatted((org.apache.poi.ss.usermodel.Cell)cell)) {
                return Cell.valueOf(cell.getDateCellValue(), rowNo, columnNo);
            }
            return Cell.valueOf(cell.getNumericCellValue(), rowNo, columnNo);
        }
        if (type == CellType.STRING) {
            return this.trimToStringCell(cell.getStringCellValue(), rowNo, columnNo);
        }
        return Cell.valueOf(rowNo, columnNo);
    }

    protected Cell trimToStringCell(String cellText, int rowNo, int columnNo) {
        if (cellText == null) {
            return Cell.valueOf(rowNo, columnNo);
        }
        return Cell.valueOf(cellText.trim(), rowNo, columnNo);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        ExcelReaderFactory.close((Closeable)this.workbook);
    }
}

