/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.excel;

import cn.devezhao.commons.excel.Cell;
import cn.devezhao.commons.excel.ExcelReader;
import cn.devezhao.commons.excel.ExcelReaderException;
import cn.devezhao.commons.excel.ExcelReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CSVReader
extends ExcelReader {
    private BufferedReader bufferedReader;
    private List<String> numberLines;

    public CSVReader(File csv) {
        this(csv, "utf-8");
    }

    public CSVReader(File csv, String charsetName) {
        try {
            InputStreamReader isr = new InputStreamReader(Files.newInputStream(csv.toPath(), new OpenOption[0]), charsetName);
            this.bufferedReader = new BufferedReader(isr);
        }
        catch (IOException e) {
            this.close();
            throw new ExcelReaderException(e);
        }
        this.rowCount = -1;
    }

    @Override
    public String[] getSheetNames() {
        return new String[]{"0"};
    }

    @Override
    public void sheetAt(int index) {
    }

    @Override
    public int getRowCount() {
        if (this.numberLines == null) {
            this.numberLines = new ArrayList<String>();
            try {
                String l;
                while ((l = this.bufferedReader.readLine()) != null) {
                    this.numberLines.add(l);
                }
            }
            catch (IOException e) {
                throw new ExcelReaderException(e);
            }
            finally {
                this.close();
            }
            this.rowCount = this.numberLines.size();
        }
        return this.rowCount;
    }

    @Override
    public Cell[] next() {
        String l;
        if (this.numberLines == null) {
            this.getRowCount();
        }
        if (this.rowIndex == this.numberLines.size()) {
            return null;
        }
        if ((l = this.numberLines.get(this.rowIndex++)) == null) {
            return null;
        }
        return this.parseLine(l, this.rowIndex - 1);
    }

    private Cell[] parseLine(String line, int rowNo) {
        String[] lines = line.split(",");
        Cell[] row = new Cell[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            row[i] = StringUtils.isEmpty((String)lines[i]) ? Cell.valueOf(rowNo, i) : Cell.valueOf(lines[i], rowNo, i);
        }
        return row;
    }

    @Override
    public void close() {
        ExcelReaderFactory.close(this.bufferedReader);
        this.bufferedReader = null;
    }
}

