/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPool {
    private static final ExecutorService EXEC = Executors.newCachedThreadPool();

    public static void exec(Runnable task) {
        EXEC.execute(task);
    }

    public static void submit(Runnable task) {
        EXEC.submit(task);
    }

    @Deprecated
    public static ExecutorService newFixedThreadPool(int nThreads) {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nThreads));
        exec.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return exec;
    }

    public static void checkblockPoolCompleted(ThreadPoolExecutor exec, int checkInterval) {
        ThreadPool.checkblockPoolCompleted(exec, checkInterval, false);
    }

    public static void checkblockPoolCompleted(ThreadPoolExecutor exec, int checkInterval, boolean shutdown) {
        int activite;
        do {
            activite = exec.getActiveCount();
            ThreadPool.waitFor(checkInterval);
        } while (activite != 0);
        if (shutdown) {
            exec.shutdown();
            try {
                exec.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void waitFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ThreadPool() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                super.run();
                EXEC.shutdownNow();
            }
        });
    }
}

