/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.hutool.core.util.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ReflectUtils {
    private static final Class<?>[] OBJECT = new Class[]{Object.class};
    private static final Class<?>[] NO_PARAM = new Class[0];
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;

    public static boolean overridesEquals(Class<?> clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class<?> clazz) {
        Method hashCode;
        try {
            hashCode = clazz.getMethod("hashCode", NO_PARAM);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static Class<?> classForName(String clazzName) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(clazzName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(clazzName);
    }

    public static Class<?> classForName(String clazzName, Class<?> caller) throws ClassNotFoundException {
        return ReflectUtils.classForName(clazzName, caller.getClassLoader());
    }

    public static Class<?> classForName(String clazzName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(clazzName, true, classLoader);
        }
        catch (Throwable throwable) {
            return ReflectUtils.classForName(clazzName);
        }
    }

    public static boolean isPublicClass(Class<?> clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isAbstractClass(Class<?> clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static String getModifierString(int mod) {
        StringBuilder sb = new StringBuilder(32);
        if (Modifier.isPublic(mod)) {
            sb.append("public ");
        }
        if (Modifier.isProtected(mod)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(mod)) {
            sb.append("private ");
        }
        if (Modifier.isAbstract(mod)) {
            sb.append("abstract ");
        }
        if (Modifier.isStatic(mod)) {
            sb.append("static ");
        }
        if (Modifier.isFinal(mod)) {
            sb.append("final ");
        }
        if (Modifier.isSynchronized(mod)) {
            sb.append("synchronized ");
        }
        if (Modifier.isTransient(mod)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(mod)) {
            sb.append("volatile ");
        }
        if (Modifier.isStrict(mod)) {
            sb.append("strictfp ");
        }
        if (Modifier.isNative(mod)) {
            sb.append("native ");
        }
        if (Modifier.isInterface(mod)) {
            sb.append("interface ");
        }
        return sb.toString().trim();
    }

    public static Class<?> getSuperclassGenricType(Class<?> clazz) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] genTypes = ((ParameterizedType)genType).getActualTypeArguments();
        if (!(genTypes[0] instanceof Class)) {
            return Object.class;
        }
        return (Class)genTypes[0];
    }

    public static Set<Class<?>> getAllSubclasses(String scanPackage, Class<?> superClass) throws IOException, ClassNotFoundException {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = scanPackage;
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "utf-8");
                ReflectUtils.scanClassesInPackage(packageName, filePath, recursive, superClass, classes);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                ReflectUtils.addScanClass(packageName + '.' + className, superClass, classes);
            }
        }
        return classes;
    }

    private static void scanClassesInPackage(String packageName, String packagePath, boolean recursive, Class<?> superClass, Set<Class<?>> classes) throws ClassNotFoundException {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles != null) {
            for (File file2 : dirfiles) {
                if (file2.isDirectory()) {
                    ReflectUtils.scanClassesInPackage(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, superClass, classes);
                    continue;
                }
                String className = file2.getName().substring(0, file2.getName().length() - 6);
                ReflectUtils.addScanClass(packageName + '.' + className, superClass, classes);
            }
        }
    }

    private static void addScanClass(String className, Class<?> superClass, Set<Class<?>> into) throws ClassNotFoundException {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        if (superClass == null || superClass.isAssignableFrom(clazz) && !superClass.equals(clazz)) {
            into.add(clazz);
        }
    }

    public static Object newObject(String clazz, Object ... params) {
        try {
            return ReflectUtil.newInstance(ReflectUtils.classForName(clazz), (Object[])params);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ReflectUtils() {
    }

    static {
        try {
            OBJECT_EQUALS = Object.class.getMethod("equals", OBJECT);
            OBJECT_HASHCODE = Object.class.getMethod("hashCode", NO_PARAM);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230 Object#equals \u6216 Object#hashCode \u65b9\u6cd5", e);
        }
    }
}

