/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ObjectUtils {
    public static boolean toBool(Object o) {
        return ObjectUtils.toBool(o, Boolean.FALSE);
    }

    public static boolean toBool(Object o, boolean defaultVal) {
        if (o == null) {
            return defaultVal;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return BooleanUtils.toBoolean((String)o.toString());
    }

    public static int toInt(Object o) {
        return ObjectUtils.toInt(o, 0);
    }

    public static int toInt(Object o, int defaultVal) {
        if (o == null) {
            return defaultVal;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return NumberUtils.toInt((String)o.toString());
    }

    public static long toLong(Object o) {
        return ObjectUtils.toLong(o, 0L);
    }

    public static long toLong(Object o, long defaultVal) {
        if (o == null) {
            return defaultVal;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return NumberUtils.toLong((String)o.toString());
    }

    public static double toDouble(Object o) {
        return ObjectUtils.toDouble(o, 0.0);
    }

    public static double toDouble(Object o, double defaultVal) {
        if (o == null) {
            return defaultVal;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return NumberUtils.toDouble((String)o.toString());
    }

    public static boolean equals(Object object, Object another) {
        if (object == null && another == null) {
            return true;
        }
        if (object == null || another == null) {
            return false;
        }
        return object.equals(another);
    }

    public static double round(double value, int scale) {
        return BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double divide(int divisor, int dividend) {
        return ObjectUtils.divide((double)divisor + 0.0, (double)dividend + 0.0);
    }

    public static double divide(double divisor, double dividend) {
        if (divisor == 0.0 || dividend == 0.0) {
            return 0.0;
        }
        return divisor / dividend;
    }
}

