/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.devezhao.commons.encoder.Base64Encoder;
import cn.devezhao.commons.encoder.UrlBase64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

public class CodecUtils {
    public static final String CODES64 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Base64Encoder BASE64_ENCODER = new Base64Encoder();
    private static final UrlBase64Encoder URL_BASE64_ENCODER = new UrlBase64Encoder();

    public static byte[] base64Encode(byte[] data) {
        int length = (data.length + 2) / 3 * 4;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(length);
        try {
            BASE64_ENCODER.encode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encoding base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] base64Decode(byte[] data) {
        int len = data.length / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            BASE64_ENCODER.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception decoding base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] base64UrlEncode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            URL_BASE64_ENCODER.encode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encoding URL safe base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] base64UrlDecode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            URL_BASE64_ENCODER.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception decoding URL safe base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Exception encoding URL string: " + e);
        }
    }

    public static String urlDecode(String text) {
        try {
            return URLDecoder.decode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Exception decoding URL string: " + e);
        }
    }

    public static String dec2any(long dec, int radix) {
        boolean isNegative;
        if (radix < 2 || radix > 62) {
            radix = 2;
        }
        if (radix == 10) {
            return String.valueOf(dec);
        }
        char[] buf = new char[65];
        int pos = 64;
        boolean bl = isNegative = dec < 0L;
        if (!isNegative) {
            dec = -dec;
        }
        while (dec <= (long)(-radix)) {
            buf[pos--] = CODES64.charAt((int)(-(dec % (long)radix)));
            dec /= (long)radix;
        }
        buf[pos] = CODES64.charAt((int)(-dec));
        return new String(buf, pos, 65 - pos);
    }

    public static long any2dec(String number, int radix) {
        long dec = 0L;
        int len = number.length() - 1;
        for (int t = 0; t <= len; ++t) {
            long digitValue = CODES64.indexOf(number.charAt(t));
            dec = dec * (long)radix + digitValue;
        }
        return dec;
    }

    public static String randomCode(int length) {
        StringBuilder code = new StringBuilder();
        SecureRandom random = new SecureRandom();
        int codeLength = CODES64.length();
        for (int i = 0; i < length; ++i) {
            code.append(CODES64.charAt(random.nextInt(codeLength)));
        }
        return code.toString();
    }

    public static String base64UrlEncode(String data) {
        return new String(CodecUtils.base64UrlEncode(data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String base64UrlDecode(String data) {
        return new String(CodecUtils.base64UrlDecode(data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String base64Encode(String data) {
        return new String(CodecUtils.base64Encode(data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String base64Decode(String data) {
        return new String(CodecUtils.base64Decode(data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String encodeUnicode(String data) {
        char[] utfBytes = data.toCharArray();
        StringBuilder buffer = new StringBuilder();
        for (char utfByte : utfBytes) {
            String hexb = Integer.toHexString(utfByte);
            if (hexb.length() <= 2) {
                hexb = "00" + hexb;
            }
            buffer.append("\\u").append(hexb);
        }
        return buffer.toString();
    }

    public static String decodeUnicode(String data) {
        int start = 0;
        StringBuilder buffer = new StringBuilder();
        while (start > -1) {
            int end = data.indexOf("\\u", start + 2);
            String charStr = end == -1 ? data.substring(start + 2) : data.substring(start + 2, end);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(letter);
            start = end;
        }
        return buffer.toString();
    }

    private CodecUtils() {
    }
}

