/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class ByteUtils {
    private static final int BUFFER_SIZE = 1024;
    private static MessageDigest md5Digest = null;

    private ByteUtils() {
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static byte[] read(InputStream stream) throws IOException {
        int read;
        ArrayList<byte[]> array = new ArrayList<byte[]>();
        byte[] buffer = new byte[102400];
        int size = 0;
        while ((read = stream.read(buffer)) > -1) {
            if (read <= 0) continue;
            byte[] chunk = new byte[read];
            System.arraycopy(buffer, 0, chunk, 0, read);
            array.add(chunk);
            size += read;
        }
        if (size <= 0) {
            throw new IllegalArgumentException("stream is empty");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(size);){
            for (byte[] chunk : array) {
                baos.write(chunk);
            }
            Object object = baos.toByteArray();
            return object;
        }
    }

    public static String read(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[102400];
        StringBuilder content = new StringBuilder();
        while ((read = reader.read(buffer)) > 0) {
            char[] chunk = new char[read];
            System.arraycopy(buffer, 0, chunk, 0, read);
            content.append(chunk);
        }
        return content.toString();
    }

    public static long size(InputStream stream) throws IOException {
        int read;
        byte[] buffer = new byte[102400];
        long size = 0L;
        while ((read = stream.read(buffer)) > -1) {
            size += (long)read;
        }
        return size;
    }

    public static long size(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[102400];
        long size = 0L;
        while ((read = reader.read(buffer)) > -1) {
            size += (long)read;
        }
        return size;
    }

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static int hash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String hash(InputStream stream) throws IOException {
        int read;
        md5Digest.reset();
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) > -1) {
            md5Digest.update(buffer, 0, read);
        }
        return ByteUtils.toHex(md5Digest.digest());
    }
}

