/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security.member;

import cn.devezhao.bizz.security.member.Member;
import cn.devezhao.bizz.security.member.User;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class MemberGroup
extends Member {
    private static final long serialVersionUID = 4050659655955435119L;
    protected final Set<Principal> allMembers = new HashSet<Principal>();

    public MemberGroup(Serializable identity, String name, boolean disabled) {
        super(identity, name, disabled);
    }

    public boolean addMember(Principal user) {
        if (this.isMember(user)) {
            return false;
        }
        return this.allMembers.add(user);
    }

    public boolean removeMember(Principal user) {
        if (!this.isMember(user)) {
            return false;
        }
        return this.allMembers.remove(user);
    }

    public boolean isMember(Principal user) {
        return this.allMembers.contains(user);
    }

    public boolean isMember(Serializable identity) {
        for (Principal user : this.allMembers) {
            if (!((User)user).getIdentity().equals(identity)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Enumeration<? extends Principal> members() {
        throw new UnsupportedOperationException("Deprecated! Please using #getMembers");
    }

    public Set<Principal> getMembers() {
        return Collections.unmodifiableSet(this.allMembers);
    }
}

