/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security.member;

import cn.devezhao.bizz.security.member.MemberGroup;
import cn.devezhao.bizz.security.member.User;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BusinessUnit
extends MemberGroup {
    private static final long serialVersionUID = -1751170855052911017L;
    private User principal;
    private BusinessUnit parentBizUnit;
    private final Set<BusinessUnit> childBizUnits = new HashSet<BusinessUnit>();

    public BusinessUnit(Serializable identity, String name, boolean disabled) {
        super(identity, name, disabled);
    }

    @Override
    public boolean addMember(Principal user) {
        if (!super.addMember(user)) {
            return false;
        }
        ((User)user).setOwningBizUnit(this);
        return true;
    }

    @Override
    public boolean removeMember(Principal user) {
        if (!super.removeMember(user)) {
            return false;
        }
        ((User)user).setOwningBizUnit(null);
        return true;
    }

    public User getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(User principal) {
        this.principal = principal;
    }

    public BusinessUnit getParent() {
        return this.parentBizUnit;
    }

    public void addChild(BusinessUnit child) {
        if (this.childBizUnits.contains(child)) {
            return;
        }
        this.childBizUnits.add(child);
        child.setParent(this);
    }

    public void removeChild(BusinessUnit child) {
        if (!this.childBizUnits.contains(child)) {
            return;
        }
        this.childBizUnits.remove(child);
        child.setParent(null);
    }

    public Set<BusinessUnit> getChildren() {
        return Collections.unmodifiableSet(this.childBizUnits);
    }

    protected void setParent(BusinessUnit parent) {
        this.parentBizUnit = parent;
    }
}

