/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview;

import android.content.Context;
import android.content.SharedPreferences;

public class PrefsManager {
    public static int SEQUENCE_NEVER_STARTED = 0;
    public static int SEQUENCE_FINISHED = -1;
    private static final String PREFS_NAME = "material_showcaseview_prefs";
    private static final String STATUS = "status_";
    private String showcaseID = null;
    private Context context;

    public PrefsManager(Context context, String showcaseID) {
        this.context = context;
        this.showcaseID = showcaseID;
    }

    boolean hasFired() {
        int status = this.getSequenceStatus();
        return status == SEQUENCE_FINISHED;
    }

    void setFired() {
        this.setSequenceStatus(SEQUENCE_FINISHED);
    }

    int getSequenceStatus() {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getInt(STATUS + this.showcaseID, SEQUENCE_NEVER_STARTED);
    }

    void setSequenceStatus(int status) {
        SharedPreferences internal = this.context.getSharedPreferences(PREFS_NAME, 0);
        internal.edit().putInt(STATUS + this.showcaseID, status).apply();
    }

    public void resetShowcase() {
        PrefsManager.resetShowcase(this.context, this.showcaseID);
    }

    static void resetShowcase(Context context, String showcaseID) {
        SharedPreferences internal = context.getSharedPreferences(PREFS_NAME, 0);
        internal.edit().putInt(STATUS + showcaseID, SEQUENCE_NEVER_STARTED).apply();
    }

    public static void resetAll(Context context) {
        SharedPreferences internal = context.getSharedPreferences(PREFS_NAME, 0);
        internal.edit().clear().apply();
    }

    public void close() {
        this.context = null;
    }
}

