/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.internal.io.DeferredFileOutputStream;

public final class SimpleMessageListenerAdapter
implements MessageHandlerFactory {
    private static final int DEFAULT_DATA_DEFERRED_SIZE = 0x500000;
    private final Collection<SimpleMessageListener> listeners;
    private final int dataDeferredSize;

    public SimpleMessageListenerAdapter(SimpleMessageListener listener) {
        this(Collections.singleton(listener), 0x500000);
    }

    public SimpleMessageListenerAdapter(Collection<SimpleMessageListener> listeners) {
        this(listeners, 0x500000);
    }

    public SimpleMessageListenerAdapter(Collection<SimpleMessageListener> listeners, int dataDeferredSize) {
        this.listeners = listeners;
        this.dataDeferredSize = dataDeferredSize;
    }

    @Override
    public MessageHandler create(MessageContext ctx) {
        return new Handler(ctx);
    }

    class Handler
    implements MessageHandler {
        final MessageContext ctx;
        String from;
        List<Delivery> deliveries = new ArrayList<Delivery>();

        public Handler(MessageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void from(String from) throws RejectException {
            this.from = from;
        }

        @Override
        public void recipient(String recipient) throws RejectException {
            boolean addedListener = false;
            for (SimpleMessageListener listener : SimpleMessageListenerAdapter.this.listeners) {
                if (!listener.accept(this.from, recipient)) continue;
                this.deliveries.add(new Delivery(listener, recipient));
                addedListener = true;
            }
            if (!addedListener) {
                throw new RejectException(553, "<" + recipient + "> address unknown.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String data(InputStream data) throws TooMuchDataException, IOException {
            if (this.deliveries.size() == 1) {
                Delivery delivery = this.deliveries.get(0);
                delivery.getListener().deliver(this.from, delivery.getRecipient(), data);
            } else {
                try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(SimpleMessageListenerAdapter.this.dataDeferredSize);){
                    int value;
                    while ((value = data.read()) >= 0) {
                        dfos.write(value);
                    }
                    for (Delivery delivery : this.deliveries) {
                        delivery.getListener().deliver(this.from, delivery.getRecipient(), dfos.getInputStream());
                    }
                }
            }
            return null;
        }

        @Override
        public void done() {
        }
    }

    static class Delivery {
        private final SimpleMessageListener listener;
        private final String recipient;

        SimpleMessageListener getListener() {
            return this.listener;
        }

        String getRecipient() {
            return this.recipient;
        }

        Delivery(SimpleMessageListener listener, String recipient) {
            this.listener = listener;
            this.recipient = recipient;
        }
    }
}

