/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class Rectangle
implements Geometry,
HasGeometry {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    private Rectangle(float x1, float y1, float x2, float y2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    static Rectangle create(double x1, double y1, double x2, double y2) {
        return new Rectangle((float)x1, (float)y1, (float)x2, (float)y2);
    }

    static Rectangle create(float x1, float y1, float x2, float y2) {
        return new Rectangle(x1, y1, x2, y2);
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float x2() {
        return this.x2;
    }

    public float y2() {
        return this.y2;
    }

    public float area() {
        return (this.x2 - this.x1) * (this.y2 - this.y1);
    }

    public Rectangle add(Rectangle r) {
        return new Rectangle(Rectangle.min(this.x1, r.x1), Rectangle.min(this.y1, r.y1), Rectangle.max(this.x2, r.x2), Rectangle.max(this.y2, r.y2));
    }

    public boolean contains(double x, double y) {
        return x >= (double)this.x1 && x <= (double)this.x2 && y >= (double)this.y1 && y <= (double)this.y2;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return r.x2 >= this.x1 && r.x1 <= this.x2 && r.y2 >= this.y1 && r.y1 <= this.y2;
    }

    @Override
    public double distance(Rectangle r) {
        if (this.intersects(r)) {
            return 0.0;
        }
        Rectangle mostLeft = this.x1 < r.x1 ? this : r;
        Rectangle mostRight = this.x1 > r.x1 ? this : r;
        double xDifference = Rectangle.max(0.0f, mostLeft.x1 == mostRight.x1 ? 0.0f : mostRight.x1 - mostLeft.x2);
        Rectangle upper = this.y1 < r.y1 ? this : r;
        Rectangle lower = this.y1 > r.y1 ? this : r;
        double yDifference = Rectangle.max(0.0f, upper.y1 == lower.y1 ? 0.0f : lower.y1 - upper.y2);
        return Math.sqrt(xDifference * xDifference + yDifference * yDifference);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2)});
    }

    public boolean equals(Object obj) {
        Optional<Rectangle> other = ObjectsHelper.asClass(obj, Rectangle.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x1), (Object)Float.valueOf(((Rectangle)other.get()).x1)) && Objects.equal((Object)Float.valueOf(this.x2), (Object)Float.valueOf(((Rectangle)other.get()).x2)) && Objects.equal((Object)Float.valueOf(this.y1), (Object)Float.valueOf(((Rectangle)other.get()).y1)) && Objects.equal((Object)Float.valueOf(this.y2), (Object)Float.valueOf(((Rectangle)other.get()).y2));
        }
        return false;
    }

    public float intersectionArea(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0f;
        }
        return Rectangle.create(Rectangle.max(this.x1, r.x1), Rectangle.max(this.y1, r.y1), Rectangle.min(this.x2, r.x2), Rectangle.min(this.y2, r.y2)).area();
    }

    public float perimeter() {
        return 2.0f * (this.x2 - this.x1) + 2.0f * (this.y2 - this.y1);
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    private static float max(float a, float b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    private static float min(float a, float b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

