/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Factory;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.geometry.Geometry;

public final class Context<T, S extends Geometry> {
    private final int maxChildren;
    private final int minChildren;
    private final Splitter splitter;
    private final Selector selector;
    private final Factory<T, S> factory;

    public Context(int minChildren, int maxChildren, Selector selector, Splitter splitter, Factory<T, S> factory) {
        Preconditions.checkNotNull((Object)splitter);
        Preconditions.checkNotNull((Object)selector);
        Preconditions.checkArgument((maxChildren > 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((minChildren >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((minChildren < maxChildren ? 1 : 0) != 0);
        Preconditions.checkNotNull(factory);
        this.selector = selector;
        this.maxChildren = maxChildren;
        this.minChildren = minChildren;
        this.splitter = splitter;
        this.factory = factory;
    }

    public int maxChildren() {
        return this.maxChildren;
    }

    public int minChildren() {
        return this.minChildren;
    }

    public Splitter splitter() {
        return this.splitter;
    }

    public Selector selector() {
        return this.selector;
    }

    public Factory<T, S> factory() {
        return this.factory;
    }
}

