/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class Point
implements Geometry {
    private final Rectangle mbr;

    private Point(float x, float y) {
        this.mbr = Rectangle.create(x, y, x, y);
    }

    static Point create(double x, double y) {
        return new Point((float)x, (float)y);
    }

    static Point create(float x, float y) {
        return new Point(x, y);
    }

    @Override
    public Rectangle mbr() {
        return this.mbr;
    }

    @Override
    public double distance(Rectangle r) {
        return this.mbr.distance(r);
    }

    public double distance(Point p) {
        return Math.sqrt(this.distanceSquared(p));
    }

    public double distanceSquared(Point p) {
        float dx = this.mbr().x1() - p.mbr().x1();
        float dy = this.mbr().y1() - p.mbr().y1();
        return dx * dx + dy * dy;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.mbr.intersects(r);
    }

    public float x() {
        return this.mbr.x1();
    }

    public float y() {
        return this.mbr.y1();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mbr});
    }

    public boolean equals(Object obj) {
        Optional<Point> other = ObjectsHelper.asClass(obj, Point.class);
        if (other.isPresent()) {
            return Objects.equal((Object)this.mbr, (Object)((Point)other.get()).mbr());
        }
        return false;
    }

    public String toString() {
        return "Point [x=" + this.x() + ", y=" + this.y() + "]";
    }
}

