/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Comparators;
import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodeAndEntries;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.OnSubscribeSearch;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.SelectorMinimalAreaIncrease;
import com.github.davidmoten.rtree.SelectorRStar;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.SplitterQuadratic;
import com.github.davidmoten.rtree.SplitterRStar;
import com.github.davidmoten.rtree.Visualizer;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rx.operators.OperatorBoundedPriorityQueue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class RTree<R> {
    private final Optional<? extends Node<R>> root;
    private final Context context;
    public static final int MAX_CHILDREN_DEFAULT_GUTTMAN = 4;
    public static final int MAX_CHILDREN_DEFAULT_STAR = 10;
    private int size;
    private static final Func1<Geometry, Boolean> ALWAYS_TRUE = new Func1<Geometry, Boolean>(){

        public Boolean call(Geometry rectangle) {
            return true;
        }
    };

    private RTree(Optional<? extends Node<R>> root, int size, Context context) {
        this.root = root;
        this.size = size;
        this.context = context;
    }

    private RTree(Node<R> root, int size, Context context) {
        this(Optional.of(root), size, context);
    }

    public RTree(Context context) {
        this(Optional.absent(), 0, context);
    }

    public static <T> RTree<T> create() {
        return new Builder().create();
    }

    public int calculateDepth() {
        return RTree.calculateDepth(this.root);
    }

    private static <R> int calculateDepth(Optional<? extends Node<R>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return RTree.calculateDepth((Node)root.get(), 0);
    }

    private static <R> int calculateDepth(Node<R> node, int depth) {
        if (node instanceof Leaf) {
            return depth + 1;
        }
        return RTree.calculateDepth(((NonLeaf)node).children().get(0), depth + 1);
    }

    public static Builder minChildren(int minChildren) {
        return new Builder().minChildren(minChildren);
    }

    public static Builder maxChildren(int maxChildren) {
        return new Builder().maxChildren(maxChildren);
    }

    public static Builder splitter(Splitter splitter) {
        return new Builder().splitter(splitter);
    }

    public static Builder selector(Selector selector) {
        return new Builder().selector(selector);
    }

    public static Builder star() {
        return new Builder().star();
    }

    public RTree<R> add(Entry<R> entry) {
        if (this.root.isPresent()) {
            List<Node<R>> nodes = ((Node)this.root.get()).add(entry);
            Node<R> node = nodes.size() == 1 ? nodes.get(0) : new NonLeaf<R>(nodes, this.context);
            return new RTree<R>(node, this.size + 1, this.context);
        }
        return new RTree(new Leaf(Lists.newArrayList((Object[])new Entry[]{entry}), this.context), this.size + 1, this.context);
    }

    public RTree<R> add(R value, Geometry geometry) {
        return this.add(Entry.entry(value, geometry));
    }

    public RTree<R> add(Iterable<Entry<R>> entries) {
        RTree<R> tree = this;
        for (Entry<R> entry : entries) {
            tree = tree.add(entry);
        }
        return tree;
    }

    public Observable<RTree<R>> add(Observable<Entry<R>> entries) {
        return entries.scan((Object)this, new Func2<RTree<R>, Entry<R>, RTree<R>>(){

            public RTree<R> call(RTree<R> tree, Entry<R> entry) {
                return tree.add(entry);
            }
        });
    }

    public Observable<RTree<R>> delete(Observable<Entry<R>> entries, final boolean all) {
        return entries.scan((Object)this, new Func2<RTree<R>, Entry<R>, RTree<R>>(){

            public RTree<R> call(RTree<R> tree, Entry<R> entry) {
                return tree.delete(entry, all);
            }
        });
    }

    public RTree<R> delete(Iterable<Entry<R>> entries, boolean all) {
        RTree<R> tree = this;
        for (Entry<R> entry : entries) {
            tree = tree.delete(entry, all);
        }
        return tree;
    }

    public RTree<R> delete(R value, Geometry geometry, boolean all) {
        return this.delete(Entry.entry(value, geometry), all);
    }

    public RTree<R> delete(R value, Geometry geometry) {
        return this.delete(Entry.entry(value, geometry), false);
    }

    public RTree<R> delete(Entry<R> entry, boolean all) {
        if (this.root.isPresent()) {
            NodeAndEntries<R> nodeAndEntries = ((Node)this.root.get()).delete(entry, all);
            if (nodeAndEntries.node().isPresent() && nodeAndEntries.node().get() == this.root.get()) {
                return this;
            }
            return new RTree<R>(nodeAndEntries.node(), this.size - nodeAndEntries.countDeleted() - nodeAndEntries.entriesToAdd().size(), this.context).add(nodeAndEntries.entriesToAdd());
        }
        return this;
    }

    public RTree<R> delete(Entry<R> entry) {
        return this.delete(entry, false);
    }

    public RTree<R> delete(Iterable<Entry<R>> entries) {
        RTree<R> tree = this;
        for (Entry<R> entry : entries) {
            tree = tree.delete(entry);
        }
        return tree;
    }

    @VisibleForTesting
    Observable<Entry<R>> search(Func1<? super Geometry, Boolean> condition) {
        if (this.root.isPresent()) {
            return Observable.create(new OnSubscribeSearch((Node)this.root.get(), condition));
        }
        return Observable.empty();
    }

    public static Func1<Geometry, Boolean> intersects(final Rectangle r) {
        return new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.intersects(r);
            }
        };
    }

    public Observable<Entry<R>> search(Rectangle r) {
        return this.search(RTree.intersects(r));
    }

    public Observable<Entry<R>> search(final Rectangle r, final double maxDistance) {
        return this.search((Func1<Geometry, Boolean>)new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) < maxDistance;
            }
        });
    }

    public Observable<Entry<R>> nearest(Rectangle r, double maxDistance, int maxCount) {
        return this.search(r, maxDistance).lift(new OperatorBoundedPriorityQueue(maxCount, Comparators.ascendingDistance(r)));
    }

    public Observable<Entry<R>> entries() {
        return this.search(ALWAYS_TRUE);
    }

    public Visualizer visualize(int width, int height, Rectangle view) {
        return new Visualizer(this, width, height, view);
    }

    public Visualizer visualize(int width, int height) {
        return this.visualize(width, height, this.calculateMaxView(this));
    }

    private Rectangle calculateMaxView(RTree<R> tree) {
        return (Rectangle)((Optional)tree.entries().reduce((Object)Optional.absent(), new Func2<Optional<Rectangle>, Entry<R>, Optional<Rectangle>>(){

            public Optional<Rectangle> call(Optional<Rectangle> r, Entry<R> entry) {
                if (r.isPresent()) {
                    return Optional.of((Object)((Rectangle)r.get()).add(entry.geometry().mbr()));
                }
                return Optional.of((Object)entry.geometry().mbr());
            }
        }).toBlocking().single()).or((Object)new Rectangle(0.0f, 0.0f, 0.0f, 0.0f));
    }

    Optional<? extends Node<R>> root() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Context context() {
        return this.context;
    }

    public static class Builder {
        private static final double DEFAULT_FILLING_FACTOR = 0.4;
        private Optional<Integer> maxChildren = Optional.absent();
        private Optional<Integer> minChildren = Optional.absent();
        private Splitter splitter = new SplitterQuadratic();
        private Selector selector = new SelectorMinimalAreaIncrease();
        private boolean star = false;

        private Builder() {
        }

        public Builder minChildren(int minChildren) {
            this.minChildren = Optional.of((Object)minChildren);
            return this;
        }

        public Builder maxChildren(int maxChildren) {
            this.maxChildren = Optional.of((Object)maxChildren);
            return this;
        }

        public Builder splitter(Splitter splitter) {
            this.splitter = splitter;
            return this;
        }

        public <T> Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder star() {
            this.selector = new SelectorRStar();
            this.splitter = new SplitterRStar();
            this.star = true;
            return this;
        }

        public <S> RTree<S> create() {
            if (!this.maxChildren.isPresent()) {
                this.maxChildren = this.star ? Optional.of((Object)10) : Optional.of((Object)4);
            }
            if (!this.minChildren.isPresent()) {
                this.minChildren = Optional.of((Object)((int)Math.round((double)((Integer)this.maxChildren.get()).intValue() * 0.4)));
            }
            return new RTree(new Context((Integer)this.minChildren.get(), (Integer)this.maxChildren.get(), this.selector, this.splitter));
        }
    }
}

