/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.util.ObjectsHelper;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class Rectangle
implements Geometry {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    public Rectangle(float x1, float y1, float x2, float y2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float x2() {
        return this.x2;
    }

    public float y2() {
        return this.y2;
    }

    public float area() {
        return Math.abs((this.x1 - this.x2) * (this.y1 - this.y2));
    }

    public Rectangle add(Rectangle r) {
        return new Rectangle(Math.min(this.x1, r.x1), Math.min(this.y1, r.y1), Math.max(this.x2, r.x2), Math.max(this.y2, r.y2));
    }

    public static Rectangle create(double x1, double y1, double x2, double y2) {
        return new Rectangle((float)x1, (float)y1, (float)x2, (float)y2);
    }

    public static Rectangle create(float x1, float y1, float x2, float y2) {
        return new Rectangle(x1, y1, x2, y2);
    }

    public boolean in(double x, double y) {
        return x >= (double)this.x1 && x <= (double)this.x2 && y >= (double)this.y1 && y <= (double)this.y2;
    }

    private boolean containsCornerOf(Rectangle r) {
        return r.in(this.x1, this.y1) || r.in(this.x2, this.y2);
    }

    private boolean intersects(Rectangle r) {
        return this.containsCornerOf(r) || r.containsCornerOf(this);
    }

    @Override
    public double distance(Rectangle r) {
        if (this.intersects(r)) {
            return 0.0;
        }
        Rectangle mostLeft = this.x1 < r.x1 ? this : r;
        Rectangle mostRight = this.x1 > r.x1 ? this : r;
        double xDifference = Math.max(0.0f, mostLeft.x1 == mostRight.x1 ? 0.0f : mostRight.x1 - mostLeft.x2);
        Rectangle upper = this.y1 < r.y1 ? this : r;
        Rectangle lower = this.y1 > r.y1 ? this : r;
        double yDifference = Math.max(0.0f, upper.y1 == lower.y1 ? 0.0f : lower.y1 - upper.y2);
        return Math.sqrt(xDifference * xDifference + yDifference * yDifference);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2)});
    }

    public boolean equals(Object obj) {
        Optional<Rectangle> other = ObjectsHelper.asClass(obj, Rectangle.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x1), (Object)Float.valueOf(((Rectangle)other.get()).x1)) && Objects.equal((Object)Float.valueOf(this.x2), (Object)Float.valueOf(((Rectangle)other.get()).x2)) && Objects.equal((Object)Float.valueOf(this.y1), (Object)Float.valueOf(((Rectangle)other.get()).y1)) && Objects.equal((Object)Float.valueOf(this.y2), (Object)Float.valueOf(((Rectangle)other.get()).y2));
        }
        return false;
    }

    public float intersectionArea(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0f;
        }
        return Rectangle.create(Math.max(this.x1, r.x1), Math.max(this.y1, r.y1), Math.min(this.x2, r.x2), Math.min(this.y2, r.y2)).area();
    }

    public float perimeter() {
        return 2.0f * (this.x2 - this.x1) + 2.0f * (this.y2 - this.y1);
    }
}

