/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.util.ImmutableStack;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class NonLeaf<T>
implements Node<T> {
    private final List<? extends Node<T>> children;
    private final Rectangle mbr;
    private final Context context;

    NonLeaf(List<? extends Node<T>> children, Context context) {
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0);
        this.context = context;
        this.children = children;
        this.mbr = Util.mbr(children);
    }

    List<? extends Node<T>> children() {
        return this.children;
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public Node<T> add(Entry<T> entry, ImmutableStack<NonLeaf<T>> stack) {
        Node<T> child = this.context.selector().select(entry.geometry().mbr(), this.children);
        return child.add(entry, stack.push(this));
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T>> subscriber) {
        for (Node<T> child : this.children) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            if (!((Boolean)criterion.call((Object)child.geometry().mbr())).booleanValue()) continue;
            child.search(criterion, subscriber);
        }
    }

    public String toString() {
        return "NonLeaf [mbr=" + this.mbr + "]";
    }

    @Override
    public Optional<Node<T>> delete(Entry<T> entry, ImmutableStack<NonLeaf<T>> stack) {
        for (Node<T> child : this.children) {
            Optional<Node<T>> result;
            if (entry.geometry().distance(child.geometry().mbr()) != 0.0 || !(result = child.delete(entry, stack.push(this))).isPresent()) continue;
            return result;
        }
        if (stack.isEmpty()) {
            return Optional.of((Object)this);
        }
        return Optional.absent();
    }

    @Override
    public int count() {
        return this.children.size();
    }
}

