/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.Capabilities;
import com.github.davidmoten.grumpy.wms.CapabilitiesProvider;
import com.github.davidmoten.grumpy.wms.CapabilitiesProviderEmpty;
import com.github.davidmoten.grumpy.wms.CapabilitiesProviderFromCapabilities;
import com.github.davidmoten.grumpy.wms.CapabilitiesProviderFromClasspath;
import com.github.davidmoten.grumpy.wms.ImageCache;
import com.github.davidmoten.grumpy.wms.ImageWriter;
import com.github.davidmoten.grumpy.wms.ImageWriterDefault;
import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.Layers;
import com.github.davidmoten.grumpy.wms.LayersBuilder;
import com.github.davidmoten.grumpy.wms.MissingMandatoryParameterException;
import com.github.davidmoten.grumpy.wms.UnknownParameterException;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import com.github.davidmoten.grumpy.wms.WmsRequestProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmsServletRequestProcessor {
    private static Logger log = LoggerFactory.getLogger(WmsServletRequestProcessor.class);
    private static final String REQUEST_GET_MAP = "GetMap";
    private static final String PARAMETER_REQUEST = "REQUEST";
    private static final Object REQUEST_GET_CAPABILITIES = "GetCapabilities";
    private static final Object REQUEST_GET_FEATURE_INFO = "GetFeatureInfo";
    private final CapabilitiesProvider capabilitiesProvider;
    private WmsRequestProcessor processor;

    public WmsServletRequestProcessor(CapabilitiesProvider capabilitiesProvider, WmsRequestProcessor processor) {
        this.capabilitiesProvider = capabilitiesProvider;
        this.processor = processor;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long t = System.currentTimeMillis();
        try {
            log.info("httpGetUrl=" + request.getRequestURL() + "?" + request.getQueryString());
            log.info("requestedByIP = ip " + request.getRemoteAddr());
            String req = request.getParameter(PARAMETER_REQUEST);
            this.setNoCacheParameters(response);
            if (REQUEST_GET_CAPABILITIES.equals(req)) {
                this.writeCapabilities(request, response);
            } else if (REQUEST_GET_MAP.equals(req)) {
                this.writeImage(request, response);
            } else if (REQUEST_GET_FEATURE_INFO.equals(req)) {
                this.writeFeatureInfo(request, response);
            } else {
                throw new UnknownParameterException("Unrecognized REQUEST parameter: " + req);
            }
            response.getOutputStream().flush();
        }
        catch (UnknownParameterException e) {
            log.warn(e.getMessage());
            throw new ServletException((Throwable)e);
        }
        catch (MissingMandatoryParameterException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            log.info("requestTimeSeconds=" + new DecimalFormat("0.000").format((double)(System.currentTimeMillis() - t) / 1000.0) + "s");
        }
    }

    private void handleException(Exception e) throws ServletException {
        if (e.getClass().getName().contains("ClientAbortException") || e.getMessage() != null && e.getMessage().contains("Broken pipe") || e.getCause() instanceof SocketException) {
            String s = e.getMessage();
            if (s == null) {
                s = e.getClass().getName();
            }
        } else {
            log.error(e.getClass().getName());
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        log.warn(e.getMessage());
    }

    private void writeCapabilities(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        String capabilities = this.capabilitiesProvider.getCapabilities(request);
        response.getOutputStream().write(capabilities.getBytes());
    }

    private void writeImage(HttpServletRequest request, HttpServletResponse response) throws MissingMandatoryParameterException, IOException {
        log.info("getting image");
        WmsRequest wmsRequest = new WmsRequest(request);
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(wmsRequest.getFormat());
        boolean cacheImage = "true".equalsIgnoreCase(request.getParameter("cacheImage"));
        this.processor.writeImage(wmsRequest, cacheImage, (OutputStream)out);
    }

    private void writeFeatureInfo(HttpServletRequest request, HttpServletResponse response) throws MissingMandatoryParameterException, IOException {
        log.info("getting feature info");
        int i = this.getI(request);
        int j = this.getJ(request);
        WmsRequest wmsRequest = new WmsRequest(request);
        response.setContentType(wmsRequest.getInfoFormat());
        this.processor.writeFeatureInfo(i, j, wmsRequest, (OutputStream)response.getOutputStream());
    }

    private int getJ(HttpServletRequest request) {
        if (request.getParameter("J") != null) {
            return Math.round(Float.parseFloat(request.getParameter("J")));
        }
        return Math.round(Float.parseFloat(request.getParameter("Y")));
    }

    private int getI(HttpServletRequest request) {
        if (request.getParameter("J") != null) {
            return Math.round(Float.parseFloat(request.getParameter("I")));
        }
        return Math.round(Float.parseFloat(request.getParameter("X")));
    }

    private void setNoCacheParameters(HttpServletResponse response) {
        response.setHeader("Expires", "-1");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static class Builder {
        private CapabilitiesProvider capabilitiesProvider = new CapabilitiesProviderEmpty();
        private ImageCache imageCache = new ImageCache();
        private Layers layers;
        private final LayersBuilder layersBuilder = LayersBuilder.builder();
        private final List<String> layersToCache = new ArrayList<String>();
        private ImageWriter imageWriter = new ImageWriterDefault();
        private Integer imageCacheSize;

        private Builder() {
        }

        public Builder capabilities(CapabilitiesProvider capabilitiesProvider) {
            this.capabilitiesProvider = capabilitiesProvider;
            return this;
        }

        public Builder capabilities(Capabilities capabilities) {
            this.capabilitiesProvider = new CapabilitiesProviderFromCapabilities(capabilities);
            return this;
        }

        public Builder capabilitiesFromClasspath(String resource) {
            this.capabilitiesProvider = CapabilitiesProviderFromClasspath.fromClasspath(resource);
            return this;
        }

        public Builder imageCache(int size) {
            this.imageCacheSize = size;
            return this;
        }

        public Builder addCachedLayer(Layer layer) {
            return this.addCachedLayer(layer.getFeatures().getName(), layer);
        }

        public Builder addCachedLayer(String name, Layer layer) {
            return this.addLayer(name, layer, true);
        }

        public Builder addLayer(Layer layer) {
            return this.addLayer(layer.getFeatures().getName(), layer);
        }

        public Builder addLayer(String name, Layer layer) {
            return this.addLayer(name, layer, false);
        }

        public Builder addLayer(String name, Layer layer, boolean cache) {
            this.layersBuilder.add(name, layer);
            if (cache) {
                this.layersToCache.add(name);
            }
            return this;
        }

        public Builder layers(Layers layers) {
            this.layers = layers;
            return this;
        }

        public Builder imageWriter(ImageWriter imageWriter) {
            this.imageWriter = imageWriter;
            return this;
        }

        public WmsServletRequestProcessor build() {
            if (this.imageCacheSize != null) {
                this.imageCache = new ImageCache(this.imageCacheSize);
            }
            for (String layer : this.layersToCache) {
                this.imageCache.add(layer);
            }
            if (this.layers == null) {
                this.layers = this.layersBuilder.build();
            }
            WmsRequestProcessor processor = new WmsRequestProcessor(this.layers, this.imageCache, this.imageWriter);
            return new WmsServletRequestProcessor(this.capabilitiesProvider, processor);
        }
    }
}

