/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.core;

import java.awt.Polygon;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class Position {
    private static final double DEFAULT_INTERPOLATION_LONGITUDE_THRESHOLD = 0.25;
    private final double lat;
    private final double lon;
    private final double alt;
    public static final double EARTH_RADIUS_KM = 6371.01;
    public static final double EARTH_CIRCUMFERENCE_KM = 40030.23642389422;

    public Position(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        this.alt = 0.0;
    }

    public Position(double lat, double lon, double alt) {
        this.lat = lat;
        this.lon = lon;
        this.alt = alt;
    }

    public static Position create(double lat, double lon) {
        return new Position(lat, lon);
    }

    public static Position position(double lat, double lon) {
        return Position.create(lat, lon);
    }

    public static Position create(double lat, double lon, double alt) {
        return new Position(lat, lon, alt);
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    public final double getAlt() {
        return this.alt;
    }

    public final String toString() {
        return "[" + this.lat + "," + this.lon + "]";
    }

    public final Position predict(double distanceKm, double courseDegrees) {
        Position.assertWithMsg(this.alt == 0.0, "Predictions only valid for Earth's surface");
        double dr = distanceKm / 6371.01;
        double latR = Math.toRadians(this.lat);
        double lonR = Math.toRadians(this.lon);
        double courseR = Math.toRadians(courseDegrees);
        double lat2Radians = Math.asin(Math.sin(latR) * Math.cos(dr) + Math.cos(latR) * Math.sin(dr) * Math.cos(courseR));
        double lon2Radians = Math.atan2(Math.sin(courseR) * Math.sin(dr) * Math.cos(latR), Math.cos(dr) - Math.sin(latR) * Math.sin(lat2Radians));
        double lon3Radians = Position.mod(lonR + lon2Radians + Math.PI, Math.PI * 2) - Math.PI;
        return new Position(FastMath.toDegrees((double)lat2Radians), FastMath.toDegrees((double)lon3Radians));
    }

    public static double toDegrees(double degrees, double minutes, double seconds) {
        return degrees + minutes / 60.0 + seconds / 3600.0;
    }

    public Double getLatitudeOnGreatCircle(Position position, double longitudeDegrees) {
        double lonR = Math.toRadians(longitudeDegrees);
        double lat1R = Math.toRadians(this.lat);
        double lon1R = Math.toRadians(this.lon);
        double lat2R = Math.toRadians(position.getLat());
        double lon2R = Math.toRadians(position.getLon());
        double sinDiffLon1RLon2R = Math.sin(lon1R - lon2R);
        if (Math.abs(sinDiffLon1RLon2R) < 1.0E-8) {
            return null;
        }
        double cosLat1R = Math.cos(lat1R);
        double cosLat2R = Math.cos(lat2R);
        double numerator = Math.sin(lat1R) * cosLat2R * Math.sin(lonR - lon2R) - Math.sin(lat2R) * cosLat1R * Math.sin(lonR - lon1R);
        double denominator = cosLat1R * cosLat2R * sinDiffLon1RLon2R;
        double radians = Math.atan(numerator / denominator);
        return FastMath.toDegrees((double)radians);
    }

    public LongitudePair getLongitudeOnGreatCircle(Position position, double latitudeDegrees) {
        double lat3 = Math.toRadians(latitudeDegrees);
        double lat1 = Math.toRadians(this.lat);
        double lon1 = Math.toRadians(this.lon);
        double lat2 = Math.toRadians(position.getLat());
        double lon2 = Math.toRadians(position.getLon());
        double l12 = lon1 - lon2;
        double sinLat1 = Math.sin(lat1);
        double cosLat2 = Math.cos(lat2);
        double cosLat3 = Math.cos(lat3);
        double cosLat1 = Math.cos(lat1);
        double sinL12 = Math.sin(l12);
        double A = sinLat1 * cosLat2 * cosLat3 * sinL12;
        double B = sinLat1 * cosLat2 * cosLat3 * Math.cos(l12) - cosLat1 * Math.sin(lat2) * cosLat3;
        double C = cosLat1 * cosLat2 * Math.sin(lat3) * sinL12;
        double longitude = Math.atan2(B, A);
        double v = Math.sqrt(this.sqr(A) + this.sqr(B));
        if (Math.abs(C) >= v) {
            return null;
        }
        double dlon = Math.acos(C / v);
        double lonCandidate1Degrees = Position.to180(FastMath.toDegrees((double)(lon1 + dlon + longitude)));
        double lonCandidate2Degrees = Position.to180(FastMath.toDegrees((double)(lon1 - dlon + longitude)));
        return new LongitudePair(lonCandidate1Degrees, lonCandidate2Degrees);
    }

    private double sqr(double d) {
        return d * d;
    }

    public final Position[] getEarthLimb(int radials) {
        Position[] result = new Position[radials];
        double radialDegrees = 0.0;
        double incDegrees = 360.0 / (double)radials;
        double quarterEarthKm = 10007.559105973554;
        Position surfacePosition = new Position(this.lat, this.lon, 0.0);
        for (int i = 0; i < radials; ++i) {
            result[i] = surfacePosition.predict(quarterEarthKm, radialDegrees);
            radialDegrees += incDegrees;
        }
        return result;
    }

    public final double getDistanceToKm(Position position) {
        double lat1 = Math.toRadians(this.lat);
        double lat2 = Math.toRadians(position.lat);
        double lon1 = Math.toRadians(this.lon);
        double lon2 = Math.toRadians(position.lon);
        double deltaLon = lon2 - lon1;
        double cosLat2 = Math.cos(lat2);
        double cosLat1 = Math.cos(lat1);
        double sinLat1 = Math.sin(lat1);
        double sinLat2 = Math.sin(lat2);
        double cosDeltaLon = Math.cos(deltaLon);
        double top = Math.sqrt(this.sqr(cosLat2 * Math.sin(deltaLon)) + this.sqr(cosLat1 * sinLat2 - sinLat1 * cosLat2 * cosDeltaLon));
        double bottom = sinLat1 * sinLat2 + cosLat1 * cosLat2 * cosDeltaLon;
        double distance = 6371.01 * Math.atan2(top, bottom);
        return Math.abs(distance);
    }

    public final double getBearingDegrees(Position position) {
        double x;
        double cosLat2;
        double lat1 = Math.toRadians(this.lat);
        double lat2 = Math.toRadians(position.lat);
        double lon1 = Math.toRadians(this.lon);
        double lon2 = Math.toRadians(position.lon);
        double dLon = lon2 - lon1;
        double sinDLon = Math.sin(dLon);
        double y = sinDLon * (cosLat2 = Math.cos(lat2));
        double course = FastMath.toDegrees((double)Math.atan2(y, x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * cosLat2 * Math.cos(dLon)));
        if (course < 0.0) {
            course += 360.0;
        }
        return course;
    }

    public static double getBearingDifferenceDegrees(double bearing1, double bearing2) {
        double result;
        if (bearing1 < 0.0) {
            bearing1 += 360.0;
        }
        if (bearing2 > 180.0) {
            bearing2 -= 360.0;
        }
        if ((result = bearing1 - bearing2) > 180.0) {
            result -= 360.0;
        }
        return result;
    }

    public final double getDistanceKmToPath(Position p1, Position p2) {
        double d = 6371.01 * Math.asin(Math.sin(this.getDistanceToKm(p1) / 6371.01) * Math.sin(Math.toRadians(this.getBearingDegrees(p1) - p1.getBearingDegrees(p2))));
        return Math.abs(d);
    }

    public static String toDegreesMinutesDecimalMinutesLatitude(double lat) {
        long degrees = Math.round(Math.signum(lat) * Math.floor(Math.abs(lat)));
        double remaining = Math.abs(lat - (double)degrees);
        String result = Math.abs(degrees) + "" + '\u00b0' + new DecimalFormat("00.00").format(remaining *= 60.0) + "'" + (lat < 0.0 ? "S" : "N");
        return result;
    }

    public static String toDegreesMinutesDecimalMinutesLongitude(double lon) {
        long degrees = Math.round(Math.signum(lon) * Math.floor(Math.abs(lon)));
        double remaining = Math.abs(lon - (double)degrees);
        String result = Math.abs(degrees) + "" + '\u00b0' + new DecimalFormat("00.00").format(remaining *= 60.0) + "'" + (lon < 0.0 ? "W" : "E");
        return result;
    }

    private static double mod(double y, double x) {
        int n;
        double mod = y - (x = Math.abs(x)) * (double)(n = (int)(y / x));
        if (mod < 0.0) {
            mod += x;
        }
        return mod;
    }

    public static void assertWithMsg(boolean assertion, String msg) {
        if (!assertion) {
            throw new RuntimeException("Assertion failed: " + msg);
        }
    }

    public final Position getPositionAlongPath(Position position, double proportion) {
        if (proportion >= 0.0 && proportion <= 1.0) {
            double courseDegrees = this.getBearingDegrees(position);
            double distanceKm = this.getDistanceToKm(position);
            Position retPosition = this.predict(proportion * distanceKm, courseDegrees);
            return retPosition;
        }
        throw new RuntimeException("Proportion must be between 0 and 1 inclusive");
    }

    public final List<Position> getPositionsAlongPath(Position position, double maxSegmentLengthKm) {
        double distanceKm = this.getDistanceToKm(position);
        ArrayList<Position> positions = new ArrayList<Position>();
        long numSegments = Math.round(Math.floor(distanceKm / maxSegmentLengthKm)) + 1L;
        positions.add(this);
        int i = 1;
        while ((long)i < numSegments) {
            positions.add(this.getPositionAlongPath(position, (double)i / (double)numSegments));
            ++i;
        }
        positions.add(position);
        return positions;
    }

    public final Position to360() {
        double lat = this.lat;
        double lon = this.lon;
        if (lon < 0.0) {
            lon += 360.0;
        }
        return new Position(lat, lon);
    }

    public final Position ensureContinuous(Position lastPosition) {
        double lon = this.lon;
        if (Math.abs(lon - lastPosition.lon) > 180.0) {
            lon = lastPosition.lon < 0.0 ? (lon -= 360.0) : (lon += 360.0);
            return new Position(this.lat, lon);
        }
        return this;
    }

    public final boolean isWithin(List<Position> positions) {
        Polygon polygon = new Polygon();
        for (Position p : positions) {
            polygon.addPoint(this.degreesToArbitraryInteger(p.lon), this.degreesToArbitraryInteger(p.lat));
        }
        int x = this.degreesToArbitraryInteger(this.lon);
        int y = this.degreesToArbitraryInteger(this.lat);
        return polygon.contains(x, y);
    }

    private int degreesToArbitraryInteger(double d) {
        return (int)Math.round(d * 3600.0);
    }

    public static List<Position> interpolateLongitude(List<? extends Position> positions) {
        return Position.interpolateLongitude(positions, 0.25);
    }

    public static List<Position> interpolateLongitude(List<? extends Position> positions, double maxLongitudeDifference) {
        ArrayList<Position> result = new ArrayList<Position>();
        Position previous = null;
        for (Position position : positions) {
            if (previous == null) {
                result.add(position);
            } else {
                double diff = Position.longitudeDiff(position.getLon(), previous.getLon());
                if (diff > maxLongitudeDifference) {
                    double delta = maxLongitudeDifference / diff;
                    double bearing = previous.getBearingDegrees(position);
                    double distanceKm = previous.getDistanceToKm(position);
                    for (double d = delta; d < 1.0; d += delta) {
                        result.add(previous.predict(d * distanceKm, bearing));
                    }
                }
                result.add(position);
            }
            previous = position;
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Position) {
            Position p = (Position)o;
            return p.lat == this.lat && p.lon == this.lon;
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.lat + this.lon);
    }

    public final double getDistanceToPathKm(List<Position> positions) {
        if (positions.size() == 0) {
            throw new RuntimeException("positions must not be empty");
        }
        if (positions.size() == 1) {
            return this.getDistanceToKm(positions.get(0));
        }
        Double distance = null;
        for (int i = 0; i < positions.size() - 1; ++i) {
            double d = this.getDistanceToSegmentKm(positions.get(i), positions.get(i + 1));
            if (distance != null && !(d < distance)) continue;
            distance = d;
        }
        return distance;
    }

    public final double getDistanceToSegmentKm(Position p1, Position p2) {
        return this.getDistanceToKm(this.getClosestIntersectionWithSegment(p1, p2));
    }

    public final Position getClosestIntersectionWithSegment(Position p1, Position p2) {
        double bearing2;
        double bearing1;
        double bearingDiff;
        if (p1.equals(p2)) {
            return p1;
        }
        double d = this.getDistanceToKm(p1);
        double proportion = d * Math.cos(Math.toRadians(bearingDiff = (bearing1 = p1.getBearingDegrees(this)) - (bearing2 = p1.getBearingDegrees(p2)))) / p1.getDistanceToKm(p2);
        if (proportion < 0.0 || proportion > 1.0) {
            if (d < this.getDistanceToKm(p2)) {
                return p1;
            }
            return p2;
        }
        return p1.getPositionAlongPath(p2, proportion);
    }

    public boolean isOutside(List<Position> path, double minDistanceKm) {
        if (this.isWithin(path)) {
            return false;
        }
        double distance = this.getDistanceToPathKm(path);
        return distance >= minDistanceKm;
    }

    public static double longitudeDiff(double a, double b) {
        a = Position.to180(a);
        b = Position.to180(b);
        return Math.abs(Position.to180(a - b));
    }

    public static double to180(double d) {
        if (d < 0.0) {
            return -Position.to180(Math.abs(d));
        }
        if (d > 180.0) {
            long n = Math.round(Math.floor((d + 180.0) / 360.0));
            return d - (double)(n * 360L);
        }
        return d;
    }

    public Position normalizeLongitude() {
        return new Position(this.lat, Position.to180(this.lon), this.alt);
    }

    public static class LongitudePair {
        private final double lon1;
        private final double lon2;

        public LongitudePair(double lon1, double lon2) {
            this.lon1 = lon1;
            this.lon2 = lon2;
        }

        public double getLon1() {
            return this.lon1;
        }

        public double getLon2() {
            return this.lon2;
        }

        public String toString() {
            return "LongitudePair [lon1=" + this.lon1 + ", lon2=" + this.lon2 + "]";
        }
    }
}

