/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;

final class JsonArraySerializer
implements Serializer<ObjectNode> {
    private final ObjectMapper mapper = new ObjectMapper();
    static final JsonArraySerializer INSTANCE = new JsonArraySerializer();

    private JsonArraySerializer() {
    }

    @Override
    public Reader<ObjectNode> createReader(InputStream in) {
        try {
            final JsonParser parser = this.mapper.getFactory().createParser(in);
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                throw new IllegalStateException("Expected an array");
            }
            return new Reader<ObjectNode>(){

                @Override
                public ObjectNode read() throws IOException {
                    if (parser.nextToken() == JsonToken.START_OBJECT) {
                        return (ObjectNode)JsonArraySerializer.this.mapper.readTree(parser);
                    }
                    parser.close();
                    return null;
                }

                @Override
                public void close() throws IOException {
                    parser.close();
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Writer<ObjectNode> createWriter(OutputStream out) {
        final OutputStreamWriter w = new OutputStreamWriter(out);
        return new Writer<ObjectNode>(){
            boolean first = true;
            boolean closed = false;

            @Override
            public void write(ObjectNode node) throws IOException {
                if (this.first) {
                    w.write("[\n");
                    this.first = false;
                } else {
                    w.write(",\n");
                }
                w.write(JsonArraySerializer.this.mapper.writeValueAsString((Object)node));
            }

            @Override
            public void flush() throws IOException {
                w.flush();
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    w.write("\n]");
                    w.close();
                    this.closed = true;
                }
            }
        };
    }
}

