/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

final class CsvSerializer
implements Serializer<CSVRecord> {
    private final CSVFormat format;
    private final Charset charset;

    CsvSerializer(CSVFormat format, Charset charset) {
        this.format = format;
        this.charset = charset;
    }

    @Override
    public Reader<CSVRecord> createReader(final InputStream in) {
        return new Reader<CSVRecord>(){
            Iterator<CSVRecord> it;
            InputStreamReader isr;

            @Override
            public CSVRecord read() throws IOException {
                if (this.it == null) {
                    this.isr = new InputStreamReader(in, CsvSerializer.this.charset);
                    this.it = CsvSerializer.this.format.parse((java.io.Reader)this.isr).iterator();
                }
                if (this.it.hasNext()) {
                    return this.it.next();
                }
                return null;
            }

            @Override
            public void close() throws IOException {
                if (this.isr != null) {
                    this.isr.close();
                }
            }
        };
    }

    @Override
    public Writer<CSVRecord> createWriter(final OutputStream out) {
        return new Writer<CSVRecord>(){
            CSVPrinter printer;
            private PrintStream ps;

            @Override
            public void write(CSVRecord value) throws IOException {
                if (this.printer == null) {
                    this.ps = new PrintStream(out, false, CsvSerializer.this.charset.name());
                    this.printer = CsvSerializer.this.format.print((Appendable)this.ps);
                    List h = value.getParser().getHeaderNames();
                    if (!h.isEmpty()) {
                        this.printer.printRecord((Iterable)h);
                    }
                }
                this.printer.printRecord((Iterable)value);
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }

            @Override
            public void flush() {
                if (this.ps != null) {
                    this.ps.flush();
                }
            }
        };
    }
}

