/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.sqlparser;

import cn.hutool.core.util.ReUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.sqlparser.ConditionExpr;
import com.github.davidfantasy.mybatisplus.generatorui.sqlparser.SelectConditionParser;
import com.google.common.base.Strings;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicParamSqlEnhancer {
    private static final Logger log = LoggerFactory.getLogger(DynamicParamSqlEnhancer.class);
    private DbType dbType;

    public DynamicParamSqlEnhancer(DbType dbType) {
        this.dbType = dbType;
    }

    public List<ConditionExpr> parseSqlDynamicConditions(String sql) {
        if (Strings.isNullOrEmpty((String)sql)) {
            throw new ServiceException("sql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            CCJSqlParser ccjSqlParser = new CCJSqlParser(sql);
            Statement statement = ccjSqlParser.Statement();
            if (statement instanceof Select) {
                SelectConditionParser parser = new SelectConditionParser();
                Select select = (Select)statement;
                select.getSelectBody().accept((SelectVisitor)parser);
                return parser.getParsedConditions();
            }
            throw new ServiceException("\u53ea\u80fd\u5904\u7406SQL\u67e5\u8be2\u8bed\u53e5");
        }
        catch (Exception e) {
            log.error("\u89e3\u6790SQL\u6761\u4ef6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ServiceException("\u89e3\u6790SQL\u6761\u4ef6\u53d1\u751f\u9519\u8bef,\u8bf7\u68c0\u67e5SQL\u8bed\u6cd5");
        }
    }

    public String enhanceDynamicConditions(String sql) {
        List<ConditionExpr> conditions = this.parseSqlDynamicConditions(sql);
        for (ConditionExpr condition : conditions) {
            Pattern pattern = Pattern.compile(condition.getFindPattern(), 2);
            sql = ReUtil.replaceAll((CharSequence)sql, (Pattern)pattern, (String)this.toDynamicSql(condition));
        }
        return sql;
    }

    public String clearIllegalStatements(String sql) {
        List<ConditionExpr> conditions = this.parseSqlDynamicConditions(sql);
        for (ConditionExpr condition : conditions) {
            if (!"in".equalsIgnoreCase(condition.getOperator())) continue;
            Pattern pattern = Pattern.compile(condition.getFindPattern(), 2);
            String replaceStr = " " + condition.getLogicOperator() + " " + condition.getLeftExpr() + " in ('')";
            sql = ReUtil.replaceAll((CharSequence)sql, (Pattern)pattern, (String)replaceStr);
        }
        return sql;
    }

    public String toDynamicSql(ConditionExpr condition) {
        StringBuilder tmp = new StringBuilder();
        if (Strings.isNullOrEmpty((String)condition.getLogicOperator())) {
            tmp.append(" 1=1 ");
        }
        tmp.append("\n<if test=\"");
        tmp.append(this.trimQuotes(condition.getParamNames().get(0)));
        tmp.append("!=null\">");
        tmp.append("\n ");
        if (!Strings.isNullOrEmpty((String)condition.getLogicOperator())) {
            tmp.append(condition.getLogicOperator());
        } else {
            tmp.append(" AND ");
        }
        tmp.append(" ");
        tmp.append(this.trimQuotes(condition.getLeftExpr()));
        tmp.append(" ");
        tmp.append(condition.getOperator());
        tmp.append(" ");
        if ("IN".equalsIgnoreCase(condition.getOperator())) {
            tmp.append("\n <foreach item=\"item\" collection=\"" + this.trimQuotes(condition.getRightExpr()) + "\" open=\"(\" separator=\",\" close=\")\">");
            tmp.append("\n #{item}");
            tmp.append("\n </foreach>");
        } else if ("LIKE".equalsIgnoreCase(condition.getOperator())) {
            tmp.append(this.getLikeConcatSql(this.trimQuotes(condition.getRightExpr())));
        } else {
            tmp.append(this.trimQuotes(condition.getRightExpr()));
            if (!Strings.isNullOrEmpty((String)condition.getMiddleOperator())) {
                tmp.append(" ");
                tmp.append(condition.getMiddleOperator());
                tmp.append(" ");
                tmp.append(this.trimQuotes(condition.getEndExpr()));
            }
        }
        tmp.append("\n</if>");
        return tmp.toString();
    }

    private String trimQuotes(String str) {
        if (Strings.isNullOrEmpty((String)str) || !str.startsWith("'")) {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    private String getLikeConcatSql(String colExpr) {
        if (DbType.MYSQL == this.dbType) {
            return "concat('%'," + colExpr + ",'%')";
        }
        if (DbType.POSTGRE_SQL == this.dbType) {
            return "concat('%'," + colExpr + ",'%')";
        }
        if (DbType.ORACLE == this.dbType) {
            return "'%' || " + colExpr + " ||'%'";
        }
        if (DbType.SQL_SERVER == this.dbType) {
            return "concat('%'," + colExpr + ",'%')";
        }
        return "concat('%'," + colExpr + ",'%')";
    }
}

