/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.sqlparser;

import cn.hutool.core.util.ReUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConditionExpr {
    private static final Pattern DYNAMIC_PARAM_PATTERN = Pattern.compile("#\\{(.*?)}");
    private String findPattern;
    private String logicOperator;
    private String leftExpr;
    private String rightExpr;
    private String operator;
    private String middleOperator;
    private String endExpr;
    private List<String> paramNames;

    public int parseDynamicParams(String content) {
        if (this.paramNames == null) {
            this.paramNames = Lists.newArrayList();
        }
        Matcher m = DYNAMIC_PARAM_PATTERN.matcher(content);
        int index = 0;
        while (m.find()) {
            String group = m.group(index);
            this.paramNames.add(group.substring(2, group.length() - 1));
            ++index;
        }
        return index;
    }

    public String getFindPattern() {
        StringBuilder pattern = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.logicOperator)) {
            pattern.append("\\s+");
            pattern.append(this.logicOperator);
            pattern.append("\\s+");
        }
        pattern.append(this.leftExpr);
        pattern.append("\\s*");
        pattern.append(this.operator);
        pattern.append("\\s*");
        pattern.append(ReUtil.escape((CharSequence)this.getRightExpr().toString()));
        if (!Strings.isNullOrEmpty((String)this.middleOperator)) {
            pattern.append("\\s+");
            pattern.append(this.middleOperator);
            pattern.append("\\s+");
            pattern.append(ReUtil.escape((CharSequence)this.getEndExpr().toString()));
        }
        return pattern.toString();
    }

    public static boolean isDynamicParam(String content) {
        return DYNAMIC_PARAM_PATTERN.matcher(content).find();
    }

    public String getLogicOperator() {
        return this.logicOperator;
    }

    public String getLeftExpr() {
        return this.leftExpr;
    }

    public String getRightExpr() {
        return this.rightExpr;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getMiddleOperator() {
        return this.middleOperator;
    }

    public String getEndExpr() {
        return this.endExpr;
    }

    public List<String> getParamNames() {
        return this.paramNames;
    }

    public void setFindPattern(String findPattern) {
        this.findPattern = findPattern;
    }

    public void setLogicOperator(String logicOperator) {
        this.logicOperator = logicOperator;
    }

    public void setLeftExpr(String leftExpr) {
        this.leftExpr = leftExpr;
    }

    public void setRightExpr(String rightExpr) {
        this.rightExpr = rightExpr;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setMiddleOperator(String middleOperator) {
        this.middleOperator = middleOperator;
    }

    public void setEndExpr(String endExpr) {
        this.endExpr = endExpr;
    }

    public void setParamNames(List<String> paramNames) {
        this.paramNames = paramNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionExpr)) {
            return false;
        }
        ConditionExpr other = (ConditionExpr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$findPattern = this.getFindPattern();
        String other$findPattern = other.getFindPattern();
        if (this$findPattern == null ? other$findPattern != null : !this$findPattern.equals(other$findPattern)) {
            return false;
        }
        String this$logicOperator = this.getLogicOperator();
        String other$logicOperator = other.getLogicOperator();
        if (this$logicOperator == null ? other$logicOperator != null : !this$logicOperator.equals(other$logicOperator)) {
            return false;
        }
        String this$leftExpr = this.getLeftExpr();
        String other$leftExpr = other.getLeftExpr();
        if (this$leftExpr == null ? other$leftExpr != null : !this$leftExpr.equals(other$leftExpr)) {
            return false;
        }
        String this$rightExpr = this.getRightExpr();
        String other$rightExpr = other.getRightExpr();
        if (this$rightExpr == null ? other$rightExpr != null : !this$rightExpr.equals(other$rightExpr)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$middleOperator = this.getMiddleOperator();
        String other$middleOperator = other.getMiddleOperator();
        if (this$middleOperator == null ? other$middleOperator != null : !this$middleOperator.equals(other$middleOperator)) {
            return false;
        }
        String this$endExpr = this.getEndExpr();
        String other$endExpr = other.getEndExpr();
        if (this$endExpr == null ? other$endExpr != null : !this$endExpr.equals(other$endExpr)) {
            return false;
        }
        List<String> this$paramNames = this.getParamNames();
        List<String> other$paramNames = other.getParamNames();
        return !(this$paramNames == null ? other$paramNames != null : !((Object)this$paramNames).equals(other$paramNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionExpr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $findPattern = this.getFindPattern();
        result = result * 59 + ($findPattern == null ? 43 : $findPattern.hashCode());
        String $logicOperator = this.getLogicOperator();
        result = result * 59 + ($logicOperator == null ? 43 : $logicOperator.hashCode());
        String $leftExpr = this.getLeftExpr();
        result = result * 59 + ($leftExpr == null ? 43 : $leftExpr.hashCode());
        String $rightExpr = this.getRightExpr();
        result = result * 59 + ($rightExpr == null ? 43 : $rightExpr.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $middleOperator = this.getMiddleOperator();
        result = result * 59 + ($middleOperator == null ? 43 : $middleOperator.hashCode());
        String $endExpr = this.getEndExpr();
        result = result * 59 + ($endExpr == null ? 43 : $endExpr.hashCode());
        List<String> $paramNames = this.getParamNames();
        result = result * 59 + ($paramNames == null ? 43 : ((Object)$paramNames).hashCode());
        return result;
    }

    public String toString() {
        return "ConditionExpr(findPattern=" + this.getFindPattern() + ", logicOperator=" + this.getLogicOperator() + ", leftExpr=" + this.getLeftExpr() + ", rightExpr=" + this.getRightExpr() + ", operator=" + this.getOperator() + ", middleOperator=" + this.getMiddleOperator() + ", endExpr=" + this.getEndExpr() + ", paramNames=" + this.getParamNames() + ")";
    }
}

