package com.datalogic.decode.configuration;

/**
 * The <code>CameraWedgeBarcodeType</code> is an enumeration defining the symbology
 * of the barcode generated by the camera wedge.
 */
public enum CameraWedgeBarcodeType {
	/**
	 * Keep the symbology of the original barcode.
	 */
	NATIVE,
	/**
	 * Convert in the QR Code symbology.
	 */
	QRCODE,
	/**
	 * Convert in the Datamatrix symbology.
	 */
	DATAMATRIX;
}
