/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dsl;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.configuration.DataSetConfig;
import com.github.database.rider.core.configuration.ExpectedDataSetConfig;
import com.github.database.rider.core.connection.ConnectionHolderImpl;
import com.github.database.rider.core.dataset.DataSetExecutorImpl;
import java.sql.Connection;
import org.dbunit.DatabaseUnitException;

public class RiderDSL {
    private static ThreadLocal<RiderDSL> RIDER_DSL_THREAD_LOCAL = new ThreadLocal();
    private Connection connection;
    private DataSetConfig dataSetConfig;
    private DBUnitConfig dbUnitConfig;

    public void createDataSet() {
        RiderDSL.validateConnection();
        DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.instance(this.dataSetConfig.getExecutorId(), new ConnectionHolderImpl(this.connection));
        if (this.dbUnitConfig != null) {
            dataSetExecutor.setDBUnitConfig(this.dbUnitConfig);
        }
        dataSetExecutor.createDataSet(this.dataSetConfig);
    }

    public void expectDataSet() throws DatabaseUnitException {
        this.expectDataSet(new ExpectedDataSetConfig());
    }

    public void expectDataSet(ExpectedDataSetConfig expectedDataSetConfig) throws DatabaseUnitException {
        RiderDSL.validateConnection();
        DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.instance(this.dataSetConfig.getExecutorId(), new ConnectionHolderImpl(this.connection));
        if (this.dbUnitConfig != null) {
            dataSetExecutor.setDBUnitConfig(this.dbUnitConfig);
        }
        dataSetExecutor.compareCurrentDataSetWith(this.dataSetConfig, expectedDataSetConfig.getIgnoreCols(), expectedDataSetConfig.getReplacers(), expectedDataSetConfig.getOrderBy(), expectedDataSetConfig.getCompareOperation());
    }

    public static DataSetConfigDSL withConnection(Connection connection) {
        RiderDSL.getInstance().connection = connection;
        return new DataSetConfigDSL();
    }

    private static RiderDSL getInstance() {
        if (RIDER_DSL_THREAD_LOCAL.get() == null) {
            RIDER_DSL_THREAD_LOCAL.set(new RiderDSL());
        }
        return RIDER_DSL_THREAD_LOCAL.get();
    }

    public static DataSetConfigDSL withConnection() {
        return RiderDSL.withConnection(RiderDSL.getInstance().connection);
    }

    private static void validateConnection() {
        if (RiderDSL.getInstance().connection == null) {
            throw new RuntimeException("Invalid jdbc connection.");
        }
    }

    public static class DBUnitConfigDSL {
        public static RiderDSL withDBUnitConfig(DBUnitConfig dbUnitConfig) {
            RiderDSL riderDSL = RiderDSL.getInstance();
            riderDSL.dbUnitConfig = dbUnitConfig;
            return riderDSL;
        }

        public static void createDataSet() {
            RiderDSL.getInstance().createDataSet();
        }

        public static void expectDataSet() throws DatabaseUnitException {
            RiderDSL.getInstance().expectDataSet();
        }

        public static void expectDataSet(ExpectedDataSetConfig expectedDataSetConfig) throws DatabaseUnitException {
            RiderDSL.getInstance().expectDataSet(expectedDataSetConfig);
        }
    }

    public static class DataSetConfigDSL {
        public static DBUnitConfigDSL withDataSetConfig(DataSetConfig dataSetConfig) {
            RiderDSL.getInstance().dataSetConfig = dataSetConfig;
            return new DBUnitConfigDSL();
        }

        public static DBUnitConfigDSL withDataSetConfig() {
            if (RiderDSL.getInstance().dataSetConfig == null) {
                RiderDSL.getInstance().dataSetConfig = new DataSetConfig();
            }
            return DataSetConfigDSL.withDataSetConfig(RiderDSL.getInstance().dataSetConfig);
        }

        public static void cleanDB() {
            RiderDSL.validateConnection();
            RiderDSL.getInstance().dataSetConfig = new DataSetConfig().cleanBefore(true);
            RiderDSL.getInstance().createDataSet();
        }
    }
}

