/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Base64;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YMLWriter
implements IDataSetConsumer {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String DOUBLE_SPACES = "  ";
    private static final Logger logger = LoggerFactory.getLogger(YMLWriter.class);
    private OutputStreamWriter out;
    private ITableMetaData metaData;

    public YMLWriter(OutputStream outputStream) throws IOException {
        this.out = new OutputStreamWriter(outputStream, "UTF-8");
    }

    public void startDataSet() throws DataSetException {
    }

    public void endDataSet() throws DataSetException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            logger.warn("Could not end dataset.", (Throwable)e);
        }
        finally {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.error("Could not close dataset writer.", (Throwable)e);
            }
        }
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        this.metaData = metaData;
        try {
            this.out.write(metaData.getTableName() + ":" + NEW_LINE);
        }
        catch (IOException e) {
            logger.warn("Could not start table.", (Throwable)e);
        }
    }

    public void endTable() throws DataSetException {
        try {
            this.out.write(NEW_LINE);
        }
        catch (IOException e) {
            logger.warn("Could end table.", (Throwable)e);
        }
    }

    public void row(Object[] values) throws DataSetException {
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (i == 0) {
                    this.out.write("  - ");
                } else {
                    this.out.write("    ");
                }
                Column currentColumn = this.metaData.getColumns()[i];
                this.out.write(this.metaData.getColumns()[i].getColumnName() + ": ");
                boolean isNumber = currentColumn.getDataType().isNumber();
                if (!isNumber) {
                    this.out.write("\"");
                }
                if (values[i] != null) {
                    if (values[i] instanceof byte[]) {
                        this.out.write(Base64.getEncoder().encodeToString((byte[])values[i]));
                    } else {
                        this.out.write(values[i].toString().replace("\\", "\\\\").replace("\"", "\\\""));
                    }
                }
                if (!isNumber) {
                    this.out.write("\"");
                }
                this.out.write(NEW_LINE);
            }
        }
        catch (Exception e) {
            logger.warn("Could not write row.", (Throwable)e);
        }
    }

    public synchronized void write(IDataSet dataSet) throws DataSetException {
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer((IDataSetConsumer)this);
        provider.produce();
    }
}

