/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.util.ClassUtils;
import com.github.database.rider.core.util.EntityManagerProvider;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.metamodel.Attribute;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.datatype.DataType;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.hibernate.SessionFactory;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BuilderUtil.class.getName());
    private static final DBUnitConfig config = DBUnitConfig.fromGlobalConfig();

    public static String convertColumnCase(Column column, DBUnitConfig config) {
        return BuilderUtil.convertCase(column.getColumnName(), config);
    }

    public static String convertCase(String value, DBUnitConfig config) {
        if (value != null && config != null && !config.isCaseSensitiveTableNames()) {
            value = Orthography.UPPERCASE == config.getCaseInsensitiveStrategy() ? value.toUpperCase() : value.toLowerCase();
        }
        return value;
    }

    public static String getColumnNameFromMetaModel(Attribute column) {
        String columnName = null;
        try {
            if (BuilderUtil.isEclipseLinkOnClasspath()) {
                columnName = ((AttributeImpl)column).getMapping().getField().getName();
            } else if (BuilderUtil.isHibernateOnClasspath() && EntityManagerProvider.isEntityManagerActive()) {
                AbstractEntityPersister entityMetadata = (AbstractEntityPersister)((SessionFactory)EntityManagerProvider.em().getEntityManagerFactory().unwrap(SessionFactory.class)).getClassMetadata(column.getJavaMember().getDeclaringClass());
                columnName = entityMetadata.getPropertyColumnNames(column.getName())[0];
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not extract database column name from column {} and type {}", new Object[]{column.getName(), column.getDeclaringType().getJavaType().getName(), e});
        }
        if (columnName == null) {
            columnName = BuilderUtil.convertCase(column.getName(), config);
        }
        return columnName;
    }

    public static boolean isHibernateOnClasspath() {
        return ClassUtils.isOnClasspath("org.hibernate.Session");
    }

    public static boolean isEclipseLinkOnClasspath() {
        return ClassUtils.isOnClasspath("org.eclipse.persistence.mappings.DirectToFieldMapping");
    }

    public static DataType resolveColumnDataType(Object value) {
        DataType columnType = DataType.UNKNOWN;
        if (value == null) {
            return columnType;
        }
        if (value instanceof Integer) {
            columnType = DataType.INTEGER;
        }
        if (value instanceof Long) {
            columnType = DataType.BIGINT_AUX_LONG;
        }
        if (value instanceof Double) {
            columnType = DataType.DOUBLE;
        }
        if (value instanceof Float) {
            columnType = DataType.FLOAT;
        }
        if (value instanceof Date) {
            columnType = DataType.DATE;
        }
        if (value instanceof Boolean) {
            columnType = DataType.BOOLEAN;
        }
        if (value instanceof BigDecimal) {
            columnType = DataType.DECIMAL;
        }
        if (value instanceof Number) {
            columnType = DataType.NUMERIC;
        }
        return columnType;
    }
}

