/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.assertion;

import com.github.database.rider.core.script.ScriptEngineManagerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dbunit.assertion.DbUnitAssert;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetAssert
extends DbUnitAssert {
    private static final Logger logger = LoggerFactory.getLogger(DbUnitAssert.class);
    private final ScriptEngineManagerWrapper manager = ScriptEngineManagerWrapper.getInstance();
    private List<Integer> comparedRowsList;

    public void initComparedRows() {
        this.comparedRowsList = new ArrayList<Integer>();
    }

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler) throws DataSetException {
        logger.debug("compareData(expectedTable={}, actualTable={}, comparisonCols={}, failureHandler={}) - start", new Object[]{expectedTable, actualTable, comparisonCols, failureHandler});
        if (expectedTable == null) {
            throw new NullPointerException("The parameter 'expectedTable' must not be null");
        }
        if (actualTable == null) {
            throw new NullPointerException("The parameter 'actualTable' must not be null");
        }
        if (comparisonCols == null) {
            throw new NullPointerException("The parameter 'comparisonCols' must not be null");
        }
        if (failureHandler == null) {
            throw new NullPointerException("The parameter 'failureHandler' must not be null");
        }
        for (int i = 0; i < expectedTable.getRowCount(); ++i) {
            if (this.skipRow(i)) continue;
            this.comparedRowsList.add(i);
            for (int j = 0; j < comparisonCols.length; ++j) {
                Difference diff;
                Object actualValue;
                DbUnitAssert.ComparisonColumn compareColumn = comparisonCols[j];
                String columnName = compareColumn.getColumnName();
                DataType dataType = compareColumn.getDataType();
                Object expectedValue = expectedTable.getValue(i, columnName);
                if (this.skipCompare(columnName, expectedValue, actualValue = actualTable.getValue(i, columnName))) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("ignoring comparison " + expectedValue + "=" + actualValue + " on column " + columnName);
                    continue;
                }
                if (expectedValue != null) {
                    if (expectedValue.toString().startsWith("regex:")) {
                        if (this.regexMatches(expectedValue.toString(), actualValue)) continue;
                        diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                        failureHandler.handle(diff);
                        continue;
                    }
                    if (this.manager.rowValueContainsScriptEngine(expectedValue)) {
                        try {
                            if (!this.manager.hasScriptExpression(expectedValue) || this.manager.getScriptAssert(expectedValue.toString(), actualValue)) continue;
                            diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                            failureHandler.handle(diff);
                            continue;
                        }
                        catch (Exception e) {
                            logger.warn(String.format("Could not evaluate script expression '%s' for table '%s', column '%s'.", expectedValue, actualTable.getTableMetaData().getTableName(), columnName), (Throwable)e);
                        }
                    }
                }
                if (dataType.compare(expectedValue, actualValue) == 0) continue;
                diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                failureHandler.handle(diff);
            }
        }
    }

    private boolean skipRow(int i) {
        return this.comparedRowsList.contains(i);
    }

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers, int rowNum, int columnNum) throws DataSetException {
        this.compareData(expectedTable, actualTable, comparisonCols, failureHandler);
    }

    private boolean regexMatches(String expectedValue, Object actualValue) {
        if (actualValue == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(expectedValue.substring(expectedValue.indexOf(58) + 1).trim());
        return pattern.matcher(actualValue.toString()).matches();
    }
}

