/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import java.util.LinkedHashMap;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;

public class TableMetaDataBuilder {
    private final String tableName;
    private final LinkedHashMap<String, Column> keysToColumns = new LinkedHashMap();
    private final DBUnitConfig config;

    public TableMetaDataBuilder(String tableName) {
        this.tableName = tableName;
        this.config = DBUnitConfig.fromGlobalConfig();
    }

    public TableMetaDataBuilder with(ITableMetaData metaData) throws DataSetException {
        return this.with(metaData.getColumns());
    }

    public TableMetaDataBuilder with(Column ... columns) {
        for (Column column : columns) {
            this.with(column);
        }
        return this;
    }

    public TableMetaDataBuilder with(Column column) {
        if (this.isUnknown(column)) {
            this.add(column);
        }
        return this;
    }

    public int numberOfColumns() {
        return this.keysToColumns.size();
    }

    public ITableMetaData build() {
        return new DefaultTableMetaData(this.tableName, this.columns());
    }

    private void add(Column column) {
        this.keysToColumns.put(this.toKey(column), column);
    }

    private String toKey(Column column) {
        return BuilderUtil.convertColumnCase(column, this.config);
    }

    private boolean isUnknown(Column column) {
        return !this.isKnown(column);
    }

    private boolean isKnown(Column column) {
        return this.keysToColumns.containsKey(this.toKey(column));
    }

    private Column[] columns() {
        return this.keysToColumns.values().toArray(new Column[this.keysToColumns.size()]);
    }
}

