/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.connection.RiderDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableNameResolver {
    private static final Logger LOG = LoggerFactory.getLogger((String)TableNameResolver.class.getName());
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private final Set<String> tableNamesCache;
    private final DBUnitConfig dbUnitConfig;

    public TableNameResolver() {
        this(DBUnitConfig.fromGlobalConfig());
    }

    public TableNameResolver(DBUnitConfig dbUnitConfig) {
        if (dbUnitConfig == null) {
            dbUnitConfig = DBUnitConfig.fromGlobalConfig();
        }
        this.dbUnitConfig = dbUnitConfig;
        this.tableNamesCache = new HashSet<String>();
    }

    public String resolveTableName(String name, RiderDataSource riderDataSource) {
        name = DBUnitConfig.Constants.RESERVED_TABLE_NAMES.contains(name.toUpperCase()) || this.getDatabaseReservedWords(riderDataSource).contains(name.toUpperCase()) ? this.escapeTableName(name, riderDataSource) : this.applyDBUnitEscapePattern(name);
        return name;
    }

    public Set<String> getTableNames(RiderDataSource riderDataSource) {
        HashSet<String> hashSet;
        block10: {
            if (this.hasTableNamesCache()) {
                return this.tableNamesCache;
            }
            HashSet<String> tables = new HashSet<String>();
            ResultSet result = this.getTablesFromMetadata(riderDataSource.getDBUnitConnection().getConnection());
            try {
                String schemaColumnLabel = this.getSchemaColumnLabel(this.getDatabaseMetaData(riderDataSource));
                while (result.next()) {
                    String schema = this.resolveSchema(result, schemaColumnLabel);
                    if (this.isSystemSchema(schema, riderDataSource)) continue;
                    String name = result.getString("TABLE_NAME");
                    name = this.resolveTableName(name, riderDataSource);
                    tables.add(schema != null && !"".equals(schema.trim()) ? schema + "." + name : name);
                }
                this.tableNamesCache.addAll(tables);
                hashSet = tables;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.warn("An exception occurred while trying to analyse the database.", (Throwable)ex);
                    return new HashSet<String>();
                }
            }
            result.close();
        }
        return hashSet;
    }

    public String resolveSchema(Connection connection) {
        String string;
        block8: {
            String schemaColumnLabel = this.getSchemaColumnLabel(connection.getMetaData());
            ResultSet tables = this.getTablesFromMetadata(connection);
            try {
                string = this.resolveSchema(tables, schemaColumnLabel);
                if (tables == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Can't resolve schema", (Throwable)e);
                    return this.dbUnitConfig.getSchema();
                }
            }
            tables.close();
        }
        return string;
    }

    private String getSchemaColumnLabel(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getSchemaTerm() == null || databaseMetaData.getSchemaTerm().isEmpty() ? TABLE_CAT : TABLE_SCHEM;
    }

    private boolean hasTableNamesCache() {
        return this.dbUnitConfig.isCacheTableNames() != false && !this.tableNamesCache.isEmpty();
    }

    private boolean isSystemSchema(String schema, RiderDataSource riderDataSource) {
        RiderDataSource.DBType dbType = riderDataSource.getDBType();
        Set<String> systemSchemas = DBUnitConfig.Constants.SYSTEM_SCHEMAS.get((Object)dbType);
        return systemSchemas != null && schema != null && systemSchemas.contains(schema.toUpperCase());
    }

    private ResultSet getTablesFromMetadata(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        return metaData.getTables(null, null, "%", new String[]{"TABLE"});
    }

    private String resolveSchema(ResultSet result, String columnLabel) {
        String schema = null;
        try {
            schema = result.getString(columnLabel);
            if (schema == null) {
                schema = this.dbUnitConfig.getSchema();
            }
        }
        catch (Exception e) {
            LOG.warn("Can't resolve schema", (Throwable)e);
            schema = this.dbUnitConfig.getSchema();
        }
        return schema;
    }

    private String applyDBUnitEscapePattern(String table) {
        boolean hasEscapePattern;
        boolean bl = hasEscapePattern = this.dbUnitConfig.getProperties().containsKey("escapePattern") && !"".equals(this.dbUnitConfig.getProperties().get("escapePattern").toString());
        if (hasEscapePattern) {
            String escapePattern = this.dbUnitConfig.getProperties().get("escapePattern").toString();
            if (table.contains(".")) {
                return table.substring(0, table.indexOf(".") + 1) + this.formatTableName(table.substring(table.indexOf(".") + 1), escapePattern);
            }
            return this.formatTableName(table, escapePattern);
        }
        return table;
    }

    private String formatTableName(String tableName, String escapePattern) {
        return escapePattern.contains("?") ? escapePattern.replace("?", tableName) : String.format("%s%s%s", escapePattern, tableName, escapePattern);
    }

    private DatabaseMetaData getDatabaseMetaData(RiderDataSource riderDataSource) {
        try {
            return this.getDatabaseMetaData(riderDataSource.getDBUnitConnection().getConnection());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not retrieve database metadata: " + e.getMessage(), e);
        }
    }

    private DatabaseMetaData getDatabaseMetaData(Connection connection) {
        try {
            return connection.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not retrieve database metadata: " + e.getMessage(), e);
        }
    }

    private Set<String> getDatabaseReservedWords(RiderDataSource riderDataSource) {
        HashSet<String> databaseReservedWords = new HashSet<String>();
        try {
            Collections.addAll(databaseReservedWords, this.getDatabaseMetaData(riderDataSource).getSQLKeywords().toUpperCase().split(","));
        }
        catch (SQLException e) {
            LOG.warn("Unable to get SQL keywords", (Throwable)e);
        }
        return databaseReservedWords;
    }

    private String getDatabaseEscapePattern(RiderDataSource riderDataSource) {
        try {
            return this.getDatabaseMetaData(riderDataSource).getIdentifierQuoteString().trim();
        }
        catch (SQLException e) {
            LOG.warn("Unable to get database escape pattern, will use empty string", (Throwable)e);
            return "";
        }
    }

    private String escapeTableName(String name, RiderDataSource riderDataSource) {
        String escapePattern = this.getDatabaseEscapePattern(riderDataSource);
        return this.formatTableName(name, escapePattern);
    }
}

