/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import com.github.database.rider.core.api.configuration.DBUnit;
import com.github.database.rider.core.api.configuration.DataSetMergingStrategy;
import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.configuration.ConnectionConfig;
import com.github.database.rider.core.configuration.DBUnitConfigPropertyResolver;
import com.github.database.rider.core.configuration.GlobalConfig;
import com.github.database.rider.core.connection.RiderDataSource;
import com.github.database.rider.core.replacers.DateTimeReplacer;
import com.github.database.rider.core.replacers.NullReplacer;
import com.github.database.rider.core.replacers.Replacer;
import com.github.database.rider.core.replacers.UnixTimestampReplacer;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.yaml.snakeyaml.Yaml;

public class DBUnitConfig {
    private String executorId;
    private Boolean cacheConnection;
    private Boolean cacheTableNames;
    private Boolean leakHunter;
    private Boolean mergeDataSets;
    private Boolean columnSensing;
    private Boolean raiseExceptionOnCleanUp;
    private Boolean disableSequenceFiltering;
    private Boolean alwaysCleanBefore;
    private Boolean alwaysCleanAfter;
    private Orthography caseInsensitiveStrategy;
    private String[] disablePKCheckFor;
    private DataSetMergingStrategy mergingStrategy;
    private RiderDataSource.DBType expectedDbType;
    private Map<String, Object> properties;
    private ConnectionConfig connectionConfig;

    public DBUnitConfig() {
        this("default");
    }

    public DBUnitConfig(String executor) {
        this.executorId = executor;
        this.initDefault();
    }

    private void initDefault() {
        if ("".equals(this.executorId)) {
            this.executorId = "default";
        }
        this.cacheConnection = true;
        this.cacheTableNames = true;
        this.leakHunter = false;
        this.caseInsensitiveStrategy = Orthography.UPPERCASE;
        this.mergingStrategy = DataSetMergingStrategy.METHOD;
        this.mergeDataSets = Boolean.FALSE;
        this.columnSensing = Boolean.FALSE;
        this.raiseExceptionOnCleanUp = Boolean.FALSE;
        this.disableSequenceFiltering = Boolean.FALSE;
        this.alwaysCleanBefore = Boolean.FALSE;
        this.alwaysCleanAfter = Boolean.FALSE;
        this.expectedDbType = RiderDataSource.DBType.UNKNOWN;
        this.initDefaultProperties();
        this.initDefaultConnectionConfig();
    }

    private void initDefaultProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.putIfAbsent(this.properties, "batchedStatements", false);
        this.putIfAbsent(this.properties, "qualifiedTableNames", false);
        this.putIfAbsent(this.properties, "schema", null);
        this.putIfAbsent(this.properties, "caseSensitiveTableNames", false);
        this.putIfAbsent(this.properties, "batchSize", 100);
        this.putIfAbsent(this.properties, "fetchSize", 100);
        this.putIfAbsent(this.properties, "allowEmptyFields", false);
        this.putIfAbsent(this.properties, "replacers", new ArrayList<Replacer>(Arrays.asList(new DateTimeReplacer(), new UnixTimestampReplacer(), new NullReplacer())));
        this.putIfAbsent(this.properties, "tableType", Collections.singletonList("TABLE"));
        this.putIfAbsent(this.properties, "prologTimeout", 1000L);
    }

    private <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    private void initDefaultConnectionConfig() {
        if (this.connectionConfig == null) {
            this.connectionConfig = new ConnectionConfig();
        }
        if (this.connectionConfig.getDriver() == null) {
            this.connectionConfig.setDriver("");
        }
        if (this.connectionConfig.getUrl() == null) {
            this.connectionConfig.setUrl("");
        }
        if (this.connectionConfig.getUser() == null) {
            this.connectionConfig.setUser("");
        }
        if (this.connectionConfig.getPassword() == null) {
            this.connectionConfig.setPassword("");
        }
    }

    public static DBUnitConfig fromCustomGlobalFile() {
        DBUnitConfig dbUnitConfig = Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream("dbunit.yml")).map(DBUnitConfig::loadDbUnitConfig).orElse(DBUnitConfig.loadDbUnitConfig(Thread.currentThread().getContextClassLoader().getResourceAsStream("dbunit.yaml")));
        return Optional.ofNullable(dbUnitConfig).orElse(new DBUnitConfig());
    }

    private static DBUnitConfig loadDbUnitConfig(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        DBUnitConfig configFromFile = (DBUnitConfig)new Yaml().loadAs(inputStream, DBUnitConfig.class);
        configFromFile.initDefaultProperties();
        configFromFile.initDefaultConnectionConfig();
        return configFromFile;
    }

    public static DBUnitConfig from(DBUnit dbUnit) {
        IDataTypeFactory factory;
        DBUnitConfig dbUnitConfig = new DBUnitConfig(dbUnit.executor());
        dbUnitConfig.cacheConnection(dbUnit.cacheConnection()).cacheTableNames(dbUnit.cacheTableNames()).leakHunter(dbUnit.leakHunter()).mergeDataSets(dbUnit.mergeDataSets()).columnSensing(dbUnit.columnSensing()).raiseExceptionOnCleanUp(dbUnit.raiseExceptionOnCleanUp()).disableSequenceFiltering(dbUnit.disableSequenceFiltering()).alwaysCleanBefore(dbUnit.alwaysCleanBefore()).alwaysCleanAfter(dbUnit.alwaysCleanAfter()).expectedDbType(dbUnit.expectedDbType()).caseInsensitiveStrategy(dbUnit.caseInsensitiveStrategy()).mergingStrategy(dbUnit.mergingStrategy()).disablePKCheckFor(dbUnit.disablePKCheckFor()).addDBUnitProperty("batchedStatements", dbUnit.batchedStatements()).addDBUnitProperty("batchSize", dbUnit.batchSize()).addDBUnitProperty("allowEmptyFields", dbUnit.allowEmptyFields()).addDBUnitProperty("fetchSize", dbUnit.fetchSize()).addDBUnitProperty("qualifiedTableNames", dbUnit.qualifiedTableNames()).addDBUnitProperty("schema", !dbUnit.schema().isEmpty() ? dbUnit.schema() : null).addDBUnitProperty("caseSensitiveTableNames", dbUnit.caseSensitiveTableNames()).addDBUnitProperty("tableType", dbUnit.tableType()).addDBUnitProperty("prologTimeout", dbUnit.prologTimeout());
        if (!"".equals(dbUnit.escapePattern())) {
            dbUnitConfig.addDBUnitProperty("escapePattern", dbUnit.escapePattern());
        }
        if (!dbUnit.dataTypeFactoryClass().isInterface()) {
            try {
                factory = dbUnit.dataTypeFactoryClass().newInstance();
                dbUnitConfig.addDBUnitProperty("datatypeFactory", factory);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to instantiate datatypeFactory", e);
            }
        }
        if (!dbUnit.metaDataHandler().isInterface()) {
            try {
                factory = dbUnit.metaDataHandler().newInstance();
                dbUnitConfig.addDBUnitProperty("metadataHandler", factory);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to instantiate metadataHandler", e);
            }
        }
        ArrayList<Replacer> dbUnitReplacers = new ArrayList<Replacer>();
        for (Class<? extends Replacer> replacerClass : dbUnit.replacers()) {
            try {
                dbUnitReplacers.add(replacerClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(replacerClass.getName() + " could not be instantiated as Replacer");
            }
        }
        List defaultReplacers = (List)dbUnitConfig.getProperties().get("replacers");
        if (defaultReplacers != null && defaultReplacers.size() > 0) {
            dbUnitReplacers.addAll(defaultReplacers);
        }
        dbUnitConfig.addDBUnitProperty("replacers", dbUnitReplacers);
        dbUnitConfig.driver(dbUnit.driver()).url(dbUnit.url()).user(dbUnit.user()).password(dbUnit.password());
        return dbUnitConfig;
    }

    public static DBUnitConfig fromGlobalConfig() {
        return GlobalConfig.instance().getDbUnitConfig();
    }

    public static DBUnitConfig from(Method method) {
        DBUnit dbUnitConfig = method.getAnnotation(DBUnit.class);
        if (dbUnitConfig == null) {
            dbUnitConfig = method.getDeclaringClass().getAnnotation(DBUnit.class);
        }
        if (dbUnitConfig != null) {
            return DBUnitConfig.from(dbUnitConfig);
        }
        return DBUnitConfig.fromGlobalConfig();
    }

    public DBUnitConfig cacheConnection(boolean cacheConnection) {
        this.cacheConnection = cacheConnection;
        return this;
    }

    public DBUnitConfig executorId(String executorId) {
        this.executorId = executorId;
        return this;
    }

    public DBUnitConfig leakHunter(boolean leakHunter) {
        this.leakHunter = leakHunter;
        return this;
    }

    public DBUnitConfig cacheTableNames(boolean cacheTables) {
        this.cacheTableNames = cacheTables;
        return this;
    }

    public DBUnitConfig mergeDataSets(boolean mergeDataSets) {
        this.mergeDataSets = mergeDataSets;
        return this;
    }

    private DBUnitConfig disableSequenceFiltering(boolean disableSequenceFiltering) {
        this.disableSequenceFiltering = disableSequenceFiltering;
        return this;
    }

    private DBUnitConfig alwaysCleanBefore(boolean alwaysCleanBefore) {
        this.alwaysCleanBefore = alwaysCleanBefore;
        return this;
    }

    private DBUnitConfig alwaysCleanAfter(boolean alwaysCleanAfter) {
        this.alwaysCleanAfter = alwaysCleanAfter;
        return this;
    }

    public DBUnitConfig columnSensing(boolean columnSensing) {
        this.columnSensing = columnSensing;
        return this;
    }

    public DBUnitConfig caseInsensitiveStrategy(Orthography orthography) {
        this.caseInsensitiveStrategy = orthography;
        return this;
    }

    public DBUnitConfig mergingStrategy(DataSetMergingStrategy dataSetMergingStrategy) {
        this.mergingStrategy = dataSetMergingStrategy;
        return this;
    }

    public DBUnitConfig addDBUnitProperty(String name, Object value) {
        this.properties.put(name, DBUnitConfigPropertyResolver.resolveProperty(value));
        return this;
    }

    public DBUnitConfig driver(String driverClass) {
        this.connectionConfig.setDriver(driverClass);
        return this;
    }

    public DBUnitConfig url(String url) {
        this.connectionConfig.setUrl(url);
        return this;
    }

    public DBUnitConfig user(String user) {
        this.connectionConfig.setUser(user);
        return this;
    }

    public DBUnitConfig password(String password) {
        this.connectionConfig.setPassword(password);
        return this;
    }

    public DBUnitConfig raiseExceptionOnCleanUp(boolean raiseExceptionOnCleanUp) {
        this.raiseExceptionOnCleanUp = raiseExceptionOnCleanUp;
        return this;
    }

    public DBUnitConfig disablePKCheckFor(String ... tables) {
        this.disablePKCheckFor = tables;
        return this;
    }

    public DBUnitConfig expectedDbType(RiderDataSource.DBType expectedDbType) {
        this.expectedDbType = expectedDbType;
        return this;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = DBUnitConfigPropertyResolver.resolveProperties(properties);
    }

    public Boolean isCacheTableNames() {
        return this.cacheTableNames;
    }

    public void setCacheTableNames(boolean cacheTableNames) {
        this.cacheTableNames = cacheTableNames;
    }

    public Boolean isCacheConnection() {
        return this.cacheConnection;
    }

    public void setCacheConnection(boolean cacheConnection) {
        this.cacheConnection = cacheConnection;
    }

    public Boolean isMergeDataSets() {
        return this.mergeDataSets;
    }

    public void setMergeDataSets(Boolean mergeDataSets) {
        this.mergeDataSets = mergeDataSets;
    }

    public Boolean isColumnSensing() {
        return this.columnSensing;
    }

    public void setColumnSensing(boolean columnSensing) {
        this.columnSensing = columnSensing;
    }

    public Boolean isLeakHunter() {
        return this.leakHunter;
    }

    public void setLeakHunter(boolean activateLeakHunter) {
        this.leakHunter = activateLeakHunter;
    }

    public Orthography getCaseInsensitiveStrategy() {
        return this.caseInsensitiveStrategy;
    }

    public void setCaseInsensitiveStrategy(Orthography caseInsensitiveStrategy) {
        this.caseInsensitiveStrategy = caseInsensitiveStrategy;
    }

    public DataSetMergingStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    public void setMergingStrategy(DataSetMergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.properties.containsKey("caseSensitiveTableNames") && Boolean.parseBoolean(this.properties.get("caseSensitiveTableNames").toString());
    }

    public Long getPrologTimeout() {
        return (Long)this.properties.getOrDefault("prologTimeout", 1000L);
    }

    public String[] getDisablePKCheckFor() {
        return this.disablePKCheckFor;
    }

    public void setDisablePKCheckFor(String[] disablePKCheckFor) {
        this.disablePKCheckFor = disablePKCheckFor;
    }

    public String getSchema() {
        return (String)this.properties.get("schema");
    }

    public boolean isRaiseExceptionOnCleanUp() {
        return this.raiseExceptionOnCleanUp;
    }

    public void setRaiseExceptionOnCleanUp(boolean raiseExceptionOnCleanUp) {
        this.raiseExceptionOnCleanUp = raiseExceptionOnCleanUp;
    }

    public Boolean isDisableSequenceFiltering() {
        return this.disableSequenceFiltering;
    }

    public void setDisableSequenceFiltering(Boolean disableSequenceFiltering) {
        this.disableSequenceFiltering = disableSequenceFiltering;
    }

    public Boolean isAlwaysCleanBefore() {
        return this.alwaysCleanBefore;
    }

    public void setAlwaysCleanBefore(Boolean alwaysCleanBefore) {
        this.alwaysCleanBefore = alwaysCleanBefore;
    }

    public Boolean isAlwaysCleanAfter() {
        return this.alwaysCleanAfter;
    }

    public void setAlwaysCleanAfter(Boolean alwaysCleanAfter) {
        this.alwaysCleanAfter = alwaysCleanAfter;
    }

    public RiderDataSource.DBType getExpectedDbType() {
        return this.expectedDbType;
    }

    public void setExpectedDbType(RiderDataSource.DBType expectedDbType) {
        this.expectedDbType = expectedDbType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBUnitConfig that = (DBUnitConfig)o;
        return Objects.equals(this.executorId, that.executorId) && Objects.equals(this.cacheConnection, that.cacheConnection) && Objects.equals(this.cacheTableNames, that.cacheTableNames) && Objects.equals(this.leakHunter, that.leakHunter) && Objects.equals(this.mergeDataSets, that.mergeDataSets) && Objects.equals(this.columnSensing, that.columnSensing) && Objects.equals(this.raiseExceptionOnCleanUp, that.raiseExceptionOnCleanUp) && Objects.equals(this.disableSequenceFiltering, that.disableSequenceFiltering) && Objects.equals(this.alwaysCleanBefore, that.alwaysCleanBefore) && Objects.equals(this.alwaysCleanAfter, that.alwaysCleanAfter) && this.caseInsensitiveStrategy == that.caseInsensitiveStrategy && Arrays.equals(this.disablePKCheckFor, that.disablePKCheckFor) && this.mergingStrategy == that.mergingStrategy && this.expectedDbType == that.expectedDbType && Objects.equals(this.properties, that.properties) && Objects.equals(this.connectionConfig, that.connectionConfig);
    }

    public int hashCode() {
        int result = Objects.hash(this.executorId, this.properties);
        result = 31 * result;
        return result;
    }

    public static class Constants {
        public static final String SEQUENCE_TABLE_NAME;
        public static final EnumMap<RiderDataSource.DBType, Set<String>> SYSTEM_SCHEMAS;
        public static final Set<String> RESERVED_TABLE_NAMES;
        public static final String DATASETS_FOLDER = "datasets/";
        public static final String DEFAULT_SQL_RESERVED_WORDS = "ABSOLUTE,ACTION,ADD,AFTER,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASC,ASENSITIVE,ASSERTION,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,AVG,BEFORE,BEGIN,BETWEEN,BIGINT,BINARY,BIT,BIT_LENGTH,BLOB,BOOLEAN,BOTH,BREADTH,BY,CALL,CALLED,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHAR_LENGTH,CHARACTER,CHARACTER_LENGTH,CHECK,CLOB,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONDITION,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONSTRUCTOR,CONTAINS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATA,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DEPTH,DEREF,DESC,DESCRIBE,DESCRIPTOR,DETERMINISTIC,DIAGNOSTICS,DISCONNECT,DISTINCT,DO,DOMAIN,DOUBLE,DROP,DYNAMIC,EACH,ELEMENT,ELSE,ELSEIF,END,EQUALS,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,EXTRACT,FALSE,FETCH,FILTER,FIRST,FLOAT,FOR,FOREIGN,FOUND,FREE,FROM,FULL,FUNCTION,GENERAL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,ITERATE,JOIN,KEY,LANGUAGE,LARGE,LAST,LATERAL,LEADING,LEAVE,LEFT,LEVEL,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOCATOR,LOOP,LOWER,MAP,MATCH,MAX,MEMBER,MERGE,METHOD,MIN,MINUTE,MODIFIES,MODULE,MONTH,MULTISET,NAMES,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,OBJECT,OCTET_LENGTH,OF,OLD,ON,ONLY,OPEN,OPTION,OR,ORDER,ORDINALITY,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PAD,PARAMETER,PARTIAL,PARTITION,PATH,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,RANGE,READ,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELATIVE,RELEASE,REPEAT,RESIGNAL,RESTRICT,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLE,ROLLBACK,ROLLUP,ROUTINE,ROW,ROWS,SAVEPOINT,SCHEMA,SCOPE,SCROLL,SEARCH,SECOND,SECTION,SELECT,SENSITIVE,SESSION,SESSION_USER,SET,SETS,SIGNAL,SIMILAR,SIZE,SMALLINT,SOME,SPACE,SPECIFIC,SPECIFICTYPE,SQL,SQLCODE,SQLERROR,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATE,STATIC,SUBMULTISET,SUBSTRING,SUM,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TABLESAMPLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TREAT,TRIGGER,TRIM,TRUE,UNDER,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,WORK,WRITE,YEAR,ZONE";

        static {
            SYSTEM_SCHEMAS = new EnumMap(RiderDataSource.DBType.class);
            RESERVED_TABLE_NAMES = new HashSet<String>();
            SEQUENCE_TABLE_NAME = System.getProperty("SEQUENCE_TABLE_NAME") == null ? "SEQ" : System.getProperty("SEQUENCE_TABLE_NAME");
            SYSTEM_SCHEMAS.put(RiderDataSource.DBType.MSSQL, Collections.singleton("SYS"));
            SYSTEM_SCHEMAS.put(RiderDataSource.DBType.H2, Collections.singleton("INFORMATION_SCHEMA"));
            HashSet<String> timescaledbSchemas = new HashSet<String>(Arrays.asList("_timescaledb_cache", "_timescaledb_catalog", "_timescaledb_internal", "_timescaledb_config", "timescaledb_information", "timescaledb_experimental"));
            SYSTEM_SCHEMAS.put(RiderDataSource.DBType.TIMESCALEDB, Collections.unmodifiableSet(timescaledbSchemas));
            Collections.addAll(RESERVED_TABLE_NAMES, DEFAULT_SQL_RESERVED_WORDS.split(","));
            if (System.getProperty("RESERVED_TABLE_NAMES") != null) {
                Collections.addAll(RESERVED_TABLE_NAMES, System.getProperty("RESERVED_TABLE_NAMES").toUpperCase().split(","));
            }
        }
    }
}

