/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;

public class JSONDataSet
extends AbstractDataSet {
    private JSONITableParser tableParser = new JSONITableParser();
    private final ObjectMapper mapper = new ObjectMapper();
    private List<ITable> tables;

    public JSONDataSet(File file) {
        this.tables = this.tableParser.getTables(file);
    }

    public JSONDataSet(InputStream is) {
        this.tables = this.tableParser.getTables(is);
    }

    protected ITableIterator createIterator(boolean reverse) throws DataSetException {
        return new DefaultTableIterator(this.tables.toArray(new ITable[this.tables.size()]));
    }

    private class JSONITableParser {
        private JSONITableParser() {
        }

        public List<ITable> getTables(File jsonFile) {
            try {
                return this.getTables(new FileInputStream(jsonFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public List<ITable> getTables(InputStream jsonStream) {
            ArrayList<ITable> tables = new ArrayList<ITable>();
            try {
                Map dataset = (Map)JSONDataSet.this.mapper.readValue(jsonStream, Map.class);
                for (Map.Entry entry : dataset.entrySet()) {
                    List rows = (List)entry.getValue();
                    ITableMetaData meta = this.getMetaData((String)entry.getKey(), rows);
                    DefaultTable table = new DefaultTable(meta);
                    int rowIndex = 0;
                    for (Map row : rows) {
                        this.fillRow(table, row, rowIndex++);
                    }
                    tables.add((ITable)table);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return tables;
        }

        private ITableMetaData getMetaData(String tableName, List<Map<String, Object>> rows) {
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            for (Map<String, Object> row : rows) {
                for (Map.Entry<String, Object> column : row.entrySet()) {
                    columns.add(column.getKey());
                }
            }
            ArrayList<Column> list = new ArrayList<Column>(columns.size());
            for (String s : columns) {
                list.add(new Column(s, DataType.UNKNOWN));
            }
            return new DefaultTableMetaData(tableName, list.toArray(new Column[list.size()]));
        }

        private void fillRow(DefaultTable table, Map<String, Object> row, int rowIndex) {
            try {
                if (!row.entrySet().isEmpty()) {
                    table.addRow();
                    for (Map.Entry<String, Object> column : row.entrySet()) {
                        table.setValue(rowIndex, column.getKey(), column.getValue());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

