/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.account;

import com.github.dactiv.showcase.common.SessionVariable;
import com.github.dactiv.showcase.common.enumeration.entity.State;
import com.github.dactiv.showcase.entity.account.User;
import com.github.dactiv.showcase.service.account.AccountManager;
import com.github.dactiv.showcase.service.account.AuthorizationRealm;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.springframework.beans.factory.annotation.Autowired;

public class JdbcAuthenticationRealm
extends AuthorizationRealm {
    @Autowired
    private AccountManager accountManager;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
        String username = usernamePasswordToken.getUsername();
        User user = this.accountManager.getUserByUsername(username);
        if (user == null) {
            throw new IncorrectCredentialsException();
        }
        if (user.getState().equals(State.Disable.getValue())) {
            throw new DisabledAccountException("\u4f60\u7684\u8d26\u6237\u5df2\u88ab\u7981\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u901a.");
        }
        SessionVariable model = new SessionVariable(user);
        return new SimpleAuthenticationInfo((Object)model, (Object)user.getPassword(), this.getName());
    }
}

