/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.foundation.audit;

import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.OperatingState;
import com.github.dactiv.showcase.entity.IdEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="TB_OPERATING_RECORD")
public class OperatingRecord
extends IdEntity {
    private static final long serialVersionUID = 1L;
    private String username;
    private String fkUserId;
    private Date startDate;
    private Date endDate;
    private String operatingTarget;
    private String ip;
    private String method;
    private Integer state;
    private String module;
    private String function;
    private String remark;

    @Column(length=32)
    @Length(min=5, max=32)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Column(length=32)
    @Length(min=32, max=32)
    public String getFkUserId() {
        return this.fkUserId;
    }

    public void setFkUserId(String fkUserId) {
        this.fkUserId = fkUserId;
    }

    @NotNull
    @Column(nullable=false)
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @NotNull
    @Column(nullable=false)
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @NotNull
    @Length(max=412)
    @Column(length=512, nullable=false)
    public String getOperatingTarget() {
        return this.operatingTarget;
    }

    public void setOperatingTarget(String operatingTarget) {
        this.operatingTarget = operatingTarget;
    }

    @NotEmpty
    @Length(max=64)
    @Column(length=64, nullable=false)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @NotEmpty
    @Length(max=256)
    @Column(length=256, nullable=false)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Min(value=1L)
    @Max(value=2L)
    @NotNull
    @Column(nullable=false)
    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    @Length(max=128)
    @Column(length=128)
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Length(max=128)
    @Column(length=128)
    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    @Lob
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Transient
    public String getStateName() {
        return SystemVariableUtils.getName(OperatingState.class, (Object)this.state);
    }
}

