/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.foundation;

import com.github.dactiv.common.spring.mvc.SpringMvcHolder;
import com.github.dactiv.common.utils.ConvertUtils;
import com.github.dactiv.common.utils.ReflectionUtils;
import com.github.dactiv.showcase.common.SessionVariable;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.common.enumeration.entity.OperatingState;
import com.github.dactiv.showcase.entity.foundation.audit.OperatingRecord;
import com.github.dactiv.showcase.service.foundation.SystemAuditManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OperatingRecordAspect {
    @Autowired
    private SystemAuditManager systemAuditManager;

    @Around(value="@annotation(com.github.dactiv.showcase.common.annotation.OperatingAudit)")
    public Object doAround(ProceedingJoinPoint point) throws Throwable {
        SessionVariable sessionVariable;
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        OperatingAudit audit = (OperatingAudit)ReflectionUtils.getAnnotation((Method)method, OperatingAudit.class);
        OperatingRecord record = new OperatingRecord();
        record.setStartDate(new Date());
        record.setMethod(method.getName());
        HttpServletRequest request = SpringMvcHolder.getRequest();
        StringBuffer sb = new StringBuffer();
        if (request != null) {
            record.setIp(this.getIpAddress(request));
            record.setOperatingTarget(request.getRequestURI());
            Map parameter = request.getParameterMap();
            if (parameter.size() > 0) {
                sb.append("<h2>request\u53c2\u6570</h2>").append("<hr>");
                for (Map.Entry entry : parameter.entrySet()) {
                    sb.append("<p>").append((String)entry.getKey()).append(":").append("<strong class='text-info'>").append(this.getParameterValue(entry.getValue())).append("</strong>").append("</p>");
                }
                sb.append("<hr>");
            }
        }
        if ((sessionVariable = SystemVariableUtils.getSessionVariable()) != null) {
            record.setFkUserId(sessionVariable.getUser().getId());
            record.setUsername(sessionVariable.getUser().getUsername());
        }
        String function = audit.function();
        String module = "";
        if (StringUtils.isEmpty((CharSequence)audit.value())) {
            OperatingAudit classAnnotation = (OperatingAudit)ReflectionUtils.getAnnotation(method.getDeclaringClass(), OperatingAudit.class);
            module = classAnnotation == null ? "" : classAnnotation.value();
        }
        record.setFunction(function);
        record.setModule(module);
        Object reaultValue = null;
        try {
            reaultValue = point.proceed();
            record.setState(OperatingState.Success.getValue());
        }
        catch (Throwable e) {
            record.setState(OperatingState.Fail.getValue());
            StringWriter outputStream = new StringWriter();
            PrintWriter printWriter = new PrintWriter(outputStream);
            e.printStackTrace(printWriter);
            String message = StringUtils.replace((String)outputStream.toString(), (String)">", (String)"&gt;");
            message = StringUtils.replace((String)message, (String)"<", (String)"&lt;");
            message = StringUtils.replace((String)message, (String)"\r\n", (String)"<br>");
            sb.append("<h2>\u5f02\u5e38\u4fe1\u606f</h2>").append("<hr>").append(message).append("<hr>");
            request.setAttribute("record", (Object)record);
            throw e;
        }
        finally {
            record.setEndDate(new Date());
            record.setRemark(sb.toString());
            this.systemAuditManager.insertOperatingRecord(record);
        }
        return reaultValue;
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.trim();
    }

    private String getParameterValue(Object value) {
        if (value.getClass().isArray()) {
            return StringUtils.join((Object[])((Object[])value), (String)",");
        }
        return ConvertUtils.convert((Object)value);
    }
}

